/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 收入明细表-全部明细
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@Data
public class TIncomeDetailVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 员工姓名
	 */
	@NotBlank(message = "员工姓名 不能为空")
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名 不能为空", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@NotBlank(message = "身份证号 不能为空")
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号 不能为空", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 客户id
	 */
	@Length(max = 32, message = "客户id 不能超过32 个字符")
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Schema(description = "客户id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@Length(max = 32, message = "客户编码 不能超过32 个字符")
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Schema(description = "客户编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@Length(max = 32, message = "项目id 不能超过32 个字符")
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Schema(description = "项目id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@Length(max = 30, message = "项目编码 不能超过30 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 费用类型：1管理费2风险金
	 */
	@Length(max = 1, message = "费用类型：1管理费2风险金 不能超过1 个字符")
	@ExcelAttribute(name = "费用类型：1管理费2风险金", maxLength = 1)
	@Schema(description = "费用类型：1管理费2风险金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用类型：1管理费2风险金")
	private String feeType;
	/**
	 * 收费方式：1按比例2金额-人数3金额-人次
	 */
	@Length(max = 1, message = "收费方式：1按比例2金额-人数3金额-人次 不能超过1 个字符")
	@ExcelAttribute(name = "收费方式：1按比例2金额-人数3金额-人次", maxLength = 1)
	@Schema(description = "收费方式：1按比例2金额-人数3金额-人次")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费方式：1按比例2金额-人数3金额-人次")
	private String feeMode;
	/**
	 * 收费标准
	 */
	@Length(max = 10, message = "收费标准 不能超过10 个字符")
	@ExcelAttribute(name = "收费标准", maxLength = 10)
	@Schema(description = "收费标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收费标准")
	private String charges;
	/**
	 * 收入来源：1社保2公积金3商险4薪资
	 */
	@NotBlank(message = "收入来源：1社保2公积金3商险4薪资 不能为空")
	@Length(max = 1, message = "收入来源：1社保2公积金3商险4薪资 不能超过1 个字符")
	@ExcelAttribute(name = "收入来源：1社保2公积金3商险4薪资", isNotEmpty = true, errorInfo = "收入来源：1社保2公积金3商险4薪资 不能为空", maxLength = 1)
	@Schema(description = "收入来源：1社保2公积金3商险4薪资")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入来源：1社保2公积金3商险4薪资")
	private String sourceType;
	/**
	 * 金额
	 */
	@NotBlank(message = "金额 不能为空")
	@ExcelAttribute(name = "金额", isNotEmpty = true, errorInfo = "金额 不能为空")
	@Schema(description = "金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("金额")
	private BigDecimal money;
	/**
	 * 生成月份
	 */
	@Length(max = 6, message = "生成月份 不能超过6 个字符")
	@ExcelAttribute(name = "生成月份", maxLength = 6)
	@Schema(description = "生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成月份")
	private String createMonth;
	/**
	 * 缴纳月份
	 */
	@Length(max = 6, message = "缴纳月份 不能超过6 个字符")
	@ExcelAttribute(name = "缴纳月份", maxLength = 6)
	@Schema(description = "缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳月份")
	private String payMonth;
	/**
	 * 数据生成时间
	 */
	@NotBlank(message = "数据生成时间 不能为空")
	@ExcelAttribute(name = "数据生成时间", isNotEmpty = true, errorInfo = "数据生成时间 不能为空", isDate = true)
	@Schema(description = "数据生成时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成时间")
	private Date createTime;
	/**
	 * 数据生成月份
	 */
	@Length(max = 6, message = "数据生成月份 不能超过6 个字符")
	@ExcelAttribute(name = "数据生成月份", maxLength = 6)
	@Schema(description = "数据生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("数据生成月份")
	private String dataCreateMonth;
	/**
	 * 来源id，红冲使用
	 */
	@NotBlank(message = "来源id，红冲使用 不能为空")
	@Length(max = 32, message = "来源id，红冲使用 不能超过32 个字符")
	@ExcelAttribute(name = "来源id，红冲使用", isNotEmpty = true, errorInfo = "来源id，红冲使用 不能为空", maxLength = 32)
	@Schema(description = "来源id，红冲使用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("来源id，红冲使用")
	private String sourceId;

}
