/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 社保公积金查询表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Data
public class TSocialFundInfoSearchVo extends TSocialFundInfo {




	/**
	 * 员工下拉多选
	 */
	@TableField(exist = false)
	@Schema(description = "员工类型下拉多选" )
	private  String[]empTypeList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	@Schema(description = "选中的idList")
	private List<String> idList;
	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;
	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

}
