/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 规则变更日志表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@TableName("t_auto_rule_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "规则变更日志表")
public class TAutoRuleLog extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 类型：0项目规则
	 */
	@ExcelAttribute(name = "类型：0项目规则")
	@ExcelProperty("类型：0项目规则")
	@Schema(description = "类型：0项目规则")
	private Integer type;
	/**
	 * 规则配置主表ID
	 */
	@ExcelAttribute(name = "规则配置主表ID", isNotEmpty = true, errorInfo = "规则配置主表ID不能为空", maxLength = 32)
	@NotBlank(message = "规则配置主表ID不能为空")
	@Length(max = 32, message = "规则配置主表ID不能超过32个字符")
	@ExcelProperty("规则配置主表ID")
	@Schema(description = "规则配置主表ID")
	private String mainId;
	/**
	 * 原来的信息
	 */
	@ExcelAttribute(name = "原来的信息", isNotEmpty = true, errorInfo = "原来的信息不能为空")
	@NotBlank(message = "原来的信息不能为空")
	@ExcelProperty("原来的信息")
	@Schema(description = "原来的信息")
	private String oldInfo;
	/**
	 * 新的信息
	 */
	@ExcelAttribute(name = "新的信息", isNotEmpty = true, errorInfo = "新的信息不能为空")
	@NotBlank(message = "新的信息不能为空")
	@ExcelProperty("新的信息")
	@Schema(description = "新的信息")
	private String newInfo;
	/**
	 * 差异的信息(属性名称，逗号隔开)
	 */
	@ExcelAttribute(name = "差异的信息(属性名称，逗号隔开)")
	@ExcelProperty("差异的信息(属性名称，逗号隔开)")
	@Schema(description = "差异的信息(属性名称，逗号隔开)")
	private String differenceInfo;

}
