package com.yifu.cloud.plus.v1.business.service.cert;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.cert.TUpdateRecord;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * @ClassName TUpdateRecordService
 * @Description 证件修改记录表
 * @Author fxj
 * @Created 2021/8/16 15:12
 * @Version 1.0
 */
public interface TUpdateRecordService extends IService<TUpdateRecord> {
    /**
     * 简单分页查询
     *
     * @param updateRecord
     * @return
     */
    IPage<TUpdateRecord> getTUpdateRecordPage(Page<TUpdateRecord> page, TUpdateRecord updateRecord);
    /**
     * 生成修改记录
     * @Author fxj
     * @Date 2021-08-16 15:14
     * @param id
     * @param module
     * @param oldInfo
     * @param newInfo
     * @param tClass
     * @return
     **/
    <T> TUpdateRecord saveModificationRecord(String id,String module,T oldInfo, T newInfo,Class<T> tClass);

    <T> TUpdateRecord saveModificationRecord(String id, String module, String differenceKey, T oldInfo, T newInfo, Class<T> tClass);

    R<List<TUpdateRecord>> getRecordsByDomainId(String domainId);
}
