/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 开户行配置表
 *
 * @author hgw
 * @date 2023-03-06 11:54:21
 */
@Data
public class TBankSetVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * bankName
	 */
	@NotBlank(message = "bankName 不能为空")
	@Length(max = 50, message = "bankName 不能超过50 个字符")
	@ExcelAttribute(name = "bankName", isNotEmpty = true, errorInfo = "bankName 不能为空", maxLength = 50)
	@Schema(description = "bankName")
	@ExcelProperty("bankName")
	private String bankName;
	/**
	 * 创建人id
	 */
	@Length(max = 64, message = "创建人id 不能超过64 个字符")
	@ExcelAttribute(name = "创建人id", maxLength = 64)
	@Schema(description = "创建人id")
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 64, message = "创建人姓名 不能超过64 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 64)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private Date createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 32, message = "更新人id 不能超过32 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 32)
	@Schema(description = "更新人id")
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private Date updateTime;

}
