/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParamVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 工资报账主表（工资条）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TSalaryAccountService extends IService<TSalaryAccount> {
    /**
     * 工资报账主表（工资条）简单分页查询
     * @param tSalaryAccount 工资报账主表（工资条）
     * @return
     */
    IPage<TSalaryAccount> getTSalaryAccountPage(Page<TSalaryAccount> page, TSalaryAccountSearchVo tSalaryAccount);
	/**
	 * @Author fxj
	 * @Description 薪资报账导出统一导出限制
	 * @Date 15:25 2024/10/23
	 * @Param
	 * @return
	**/
	void exportAsso(HttpServletResponse response, TSalaryAccountSearchVo searchVo,int type);

    void listExport(HttpServletResponse response, TSalaryAccountSearchVo searchVo);

	/**
	 * @Description: 审核人导出
	 * @Author: hgw
	 * @Date: 2023/2/17 11:57
	 * @return: void
	 **/
	void auditExport(HttpServletResponse response, TSalaryAccountSearchVo searchVo);

	void exportError(HttpServletResponse response, String errorMessage);

	/**
	 * @param salaryId
	 * @Description: 根据工资id，返回报账明细（字段较少且有计算，其他地方勿用）
	 * @Author: hgw
	 * @Date: 2022/9/2 16:48
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getListByIncome(String salaryId);

    List<TSalaryAccount> noPageDiy(TSalaryAccountSearchVo searchVo);

	List<SalaryAccountExportVo> noPageDiyLast(TSalaryAccountSearchVo searchVo,List<String> deptNos);

	/**
	 * @param searchVo
	 * @Description: 无需权限仅按照工资id查询报账
	 * @Author: hgw
	 * @Date: 2022/10/24 16:36
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getAccountListBySalaryId(TSalaryAccountSearchVo searchVo);

	/**
	 * @param applyNo 薪酬申请编号
	 * @Description: 导出报账专用hgw
	 * @Author: hgw
	 * @Date: 2024/4/18 11:00
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccountExportByEkpVo> getAccountListByApplyNo(String applyNo);

	/**
	 * @param settleId
	 * @param settleMonth
	 * @Description: 版本2.6.6判重：对同一“结算主体”、同一“结算月份”、同一“报表类型”、同一“工资月份”、同一“身份证号”、同一“应发金额”进行校验
	 *  校验导入数据重复的Map格式：#身份证号_工资月份_报表类型_应发金额
	 * @Author: hgw
	 * @Date: 2021/9/17 18:06
	 * @return: java.util.Map<java.lang.String, java.lang.Integer>
	 **/
	Map<String, Integer> getAccountCheckMap(String settleId, String settleMonth, String salaryType);

	Map<String, BigDecimal> getAccountSpecialMap(String invoiceTitle, String unitId, String salaryMonth);

	/**
	 * @param empIdCard
	 * @param nowYear
	 * @Description: 获取当前年最小计税月
	 * @Author: hgw
	 * @Date: 2022/1/19 17:57
	 * @return: java.lang.String
	 **/
	String getMinTaxMonthByNowYear(String empIdCard, int nowYear);

	/**
	 * @param empIdCardList
	 * @param nowYear
	 * @Description: 获取最小计税月的map
	 * @Author: hgw
	 * @Date: 2023/2/8 17:19
	 * @return: java.util.Map<java.lang.String, java.lang.String>
	 **/
	Map<String, String> getMinTaxMonthByNowYearAndList(List<String> empIdCardList, int nowYear);

	/**
	 * @Author fxj
	 * @Description 获取有工资无社保数据  3个月的工资
	 * @Date 17:21 2022/8/16
	 * @Param
	 * @return
	**/
	List<THaveSalaryNosocial> getLastMonthTHaveSalaryNosocial(String month);

	/**
	 * @Description: 薪资类型互斥校验 获取本年度身份证号列表
	 * @Author: huyc
	 * @Date: 2022/8/18
	 * @return:
	 **/
	List<String> getAccountYearCheckMap();

	/**
	 * @param salaryId
	 * @Description: 获取薪资数据
	 * @Author: hgw
	 * @Date: 2022/8/29 16:54
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam>
	 **/
	List<EkpSalaryParamVo> getEkpSalaryParamList(String salaryId);

	/**
	 * @param salaryId 工资表id
	 * @Description: 退表回退状态
	 * @Author: hgw
	 * @Date: 2022/11/8 15:41
	 * @return: void
	 **/
	void backSalaryBySalaryId(String salaryId);

	/**
	 * @param viewVo
	 * @Description: 更新薪资结算状态
	 * @Author: huyc
	 * @Date: 2022/12/26 17:56
	 * @return: R
	 **/
	Boolean updateSalarySettleStatus(List<EkpSocialViewVo> viewVo);

	/**
	 * @param page 分页
	 * @param settlementFormVo 结算单Vo
	 * @Description: B端薪酬第一个统计列表
	 * @Author: hgw
	 * @Date: 2020/8/21 11:38
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>
	 **/
	IPage<SettlementFormVo> getSettlementFormVoPage(Page<SettlementFormVo> page, SettlementFormVo settlementFormVo
			, List<String> settleDepartIdList);

	/**
	 * @param salaryFormId 结算单id
	 * @Description: 工资详情-上面的统计
	 * @Author: hgw
	 * @Date: 2020-8-21 17:55:24
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>
	 **/
	SettlementFormVo getSettlementFormVoBySalaryFormId(String salaryFormId);

	/**
	 * @param page
	 * @param salaryAccountAndItemVo
	 * @Description:  获取报账以及薪资
	 * @Author: hgw
	 * @Date: 2020/8/21 15:32
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SalaryAccountAndItemVo>
	 **/
	IPage<SalaryAccountAndItemVo> getSalaryAccountAndItemVoPage(Page<SalaryAccountAndItemVo> page
			, SalaryAccountAndItemVo salaryAccountAndItemVo);

	/**
	 * @Description: 根据idList获取报账信息
	 * @Author: hgw
	 * @Date: 2023/2/2 17:42
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getListByIdList(List<String> idList);

	// 收入证明使用的
	List<String> getAccountIdForProve(String startMouth, String endMouth, String emIdCard, String settleDepartId);
	List<String> getAccountMonthForProve(String startMouth, String endMouth, String emIdCard, String settleDepartId);
	/**
	 * @param salaryId
	 * @Description: 薪资详情里的金额合计
	 * @Author: hgw
	 * @Date: 2023/2/23 15:36
	 * @return: com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryAccountSumVo
	 **/
	TSalaryAccountSumVo getAccountSumBySalaryId(String salaryId);

	List<TSalaryAccount> allYearExport(TSalaryAccountSearchVo tSalaryAccount);

	List<TSalaryTypeThreeExportEkpVo> getAccountThreeListByApplyNo(String applyNo);

	List<TSalaryTypeFourExportEkpVo> getAccountFourListByApplyNo(String applyNo);

	/**
	 * @param salaryId 主表id
	 * @Description: 获取报账身份证——提交校验使用
	 * @Author: hgw
	 * @Date: 2025/1/14 15:30
	 * @return: java.util.List<java.lang.String>
	 **/
	List<TSalaryAccount> getIdCardListBySalaryId(String salaryId);

}
