package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.EmpBusinessConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ServiceNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.social.service.TPaymentInfoService;
import com.yifu.cloud.plus.v1.yifu.social.service.TProvidentFundService;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialInfoService;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * B端社保相关接口
 * @Author fxj
 * @Date 2020-08-25
 * @return
 **/
@RestController
@AllArgsConstructor
@RequestMapping(value = "/customerBusiness/dispatchBusiness")
@Tag(name = "B端社保相关接口")
@Slf4j
@SuppressWarnings({"SpringJavaInjectionPointsAutowiringInspection"})
public class DispatchBusinessController {

    private final TSocialInfoService tSocialInfoService;

    private final TProvidentFundService tProvidentFundService;

    private final TPaymentInfoService tPaymentInfoService;

    /**
     * 通过ID查询员工对应社保的派增派减数据
     * @Author fxj
     * @Date 2020-08-25
     * @param empId
     * @return
     **/
    @Operation(description = "通过ID查询员工对应社保的派增派减数据")
    @GetMapping("/getSocialAddOrReduceByEmpId")
    public R<SocialAddAndReduceVo> getSocialAddOrReduceByEmpId(@RequestParam(value = "empId" ) String empId) {
        return new R<>(tSocialInfoService.getAddOrReduceInfoByEmpId(empId));
    }
    /**
     * 通过ID查询员工对应公积金的派增派减数据
     * @Author fxj
     * @Date 2020-08-25
     * @param empId
     * @return
     **/
    @Operation(description = "通过ID查询员工对应公积金的派增派减数据")
    @GetMapping("/getFundAddOrReduceByEmpId")
    public R<FundAddAndReduceVo> getFundAddOrReduceByEmpId(@RequestParam(value = "empId" ) String empId) {
        return new R<>(tProvidentFundService.getAddOrReduceInfoByEmpId(empId));
    }

    /**
     * 按年查询指定人的缴费库数据
     * @Author fxj
     * @Date 2020-08-25
     * @param year
     * @param empId
     * @return
     **/
    @Operation(description = "按年查询指定人的缴费库数据：年格式YYYY")
    @GetMapping("/getPaymentByYearAndEmpId")
    public R<List<PaymentBusinessPageVo>> getPaymentByYearAndEmpId(@RequestParam(value = "year" ) String year, @RequestParam(value = "empId" ) String empId) {
        if (!Common.isNotNull(year) && !Common.isNotNull(empId)){
            return R.failed("请传参年分和员工ID！");
        }
        return new R<>(tPaymentInfoService.getPaymentByYearAndEmpId(year,empId));
    }

    /**
     * 按年月查询指定人的缴费库数据：年月格式 yyyyMM
     * @Author fxj
     * @Date 2020-08-25
     * @param month
     * @param empId
     * @return
     **/
    @Operation(description = "按年月查询指定人的缴费库数据：年月格式 yyyyMM")
    @GetMapping("/getPaymentByMonthAndEmpId")
    public R<PaymentBusinessPageVo> getPaymentByMonthAndEmpId(@RequestParam(value = "month" ) String month, @RequestParam(value = "empId" ) String empId) {
        if (!Common.isNotNull(month) && !Common.isNotNull(empId)){
            return R.failed("请传参月份和员工ID！");
        }
        return new R<>(tPaymentInfoService.getPaymentByMonthAndEmpId(month,empId));
    }
    /**
     * B端社保公积金列表查询
     * @Author fxj
     * @Date 2020-08-28
     * @param page
     * @param socialAndFundBusinessPageVo
     * @return
     **/
    @Operation(description = "B端社保公积金列表查询接口")
    @GetMapping("/getSocialAndFundBusinessPage")
    public R<List<SocialAndFundBusinessPageVo>> getSocialAndFundBusinessPage(Page<SocialAndFundBusinessPageVo> page, SocialAndFundBusinessPageVo socialAndFundBusinessPageVo) {
        YifuUser user = SecurityUtils.getUser();
        if (user == null) {
            return R.failed("请登录!");
        }
        if (null == socialAndFundBusinessPageVo || !Common.isNotNull(socialAndFundBusinessPageVo.getYear())){
            return R.failed("请选择年份！");
        }
        List<String> settleDomainIds = new ArrayList<>();
        boolean flag =  !SecurityUtils.isHaveAllOrg(ServiceNameConstants.CLIENT_ID_HR_B, user);
        if (flag){
            settleDomainIds = user.getSettleIdList();
            if (Common.isEmpty(settleDomainIds)) {
                return R.failed(EmpBusinessConstants.noSettleDomainAuth);
            }
            if (Common.isNotNull(socialAndFundBusinessPageVo.getSettleDomainId())){
                // 无权限提示  有权限 按结算主体/项目ID 查询
                if (checkUserAuth(socialAndFundBusinessPageVo.getSettleDomainId(),settleDomainIds)){
                    return R.failed(EmpBusinessConstants.noSettleDomainAuth);
                }
                settleDomainIds = null;
            }
        // 管理员权限特殊处理
        }else {
            if (Common.isEmpty(socialAndFundBusinessPageVo.getSettleDomainId())){
                return new R<>(null);
            }
        }
        return new R<>(tPaymentInfoService.getSocialAndFundBusinessPage(page, socialAndFundBusinessPageVo, settleDomainIds));
    }

	private static boolean checkUserAuth(String idStr, List<String> settleDomainIds) {
		for (String id:settleDomainIds){
			if (id.equals(idStr)){
				return  false;
			}
		}
		return true;
	}


    /**
     * 按月查询对应权限的缴费库数据
     * @Author fxj
     * @Date 2020-08-31
     * @param paymentBusinessPageVo
     * @param type 0 查询所有  1  查询对应月份派增的人员缴费库
     * @return
     **/
    @Operation(description = "按月查询对应权限的缴费库数据：格式yyyyMM；type 0 查询所有  1  查询对应月份派增的人员缴费库")
    @GetMapping("/getPaymentByMonthAndAuth")
    public R<IPage<PaymentBusinessPageVo>> getPaymentByMonthAndAuth(Page<PaymentBusinessPageVo> page,
                                                                    PaymentBusinessPageVo paymentBusinessPageVo,
                                                                   @RequestParam(value = "type" , required = false) String type) {
        if (null == paymentBusinessPageVo || !Common.isNotNull(paymentBusinessPageVo.getMonth())){
            return R.failed("请选择年月！");
        }
        YifuUser user = SecurityUtils.getUser();
        if (user == null) {
            return R.failed("请登录!");
        }
        List<String> settleDomainIds = new ArrayList<>();
        boolean flag = !Common.isNotNull(paymentBusinessPageVo.getSettleDomainId()) && !SecurityUtils.isHaveAllOrg(ServiceNameConstants.CLIENT_ID_HR_B, user);
        if (flag){
            settleDomainIds = user.getSettleIdList();
            if (settleDomainIds == null || settleDomainIds.isEmpty()) {
                return R.failed(EmpBusinessConstants.noSettleDomainAuth);
            }
        }
        if (!Common.isNotNull(paymentBusinessPageVo.getSettleDomainId()) && !Common.isNotNull(settleDomainIds)){
            return  R.failed(EmpBusinessConstants.selectSettleDomainOrCallManager);
        }
        return new R<>(tPaymentInfoService.getPaymentByMonthAndAuth(page,paymentBusinessPageVo,settleDomainIds,type));
    }

    /**
     * 按年月查询指定结算主体或权限内的缴费库数据统计
     * @Author fxj
     * @Date 2020-08-31
     * @param month
     * @param settleDomainId
     * @return
     **/
    @Operation(description = "按年月查询指定结算主体或权限内的缴费库数据统计")
    @GetMapping("/getPaymentBusinessPageDetailByMonthAndAuth")
    public R<PaymentBusinessPageDetail> getPaymentBusinessPageDetailByMonthAndAuth(@RequestParam String month
			, @RequestParam(value = "settleDomainId" , required = false) String settleDomainId) {
        if (!Common.isNotNull(month)){
            return R.failed("请传参月份！");
        }
        YifuUser user = SecurityUtils.getUser();
        if (user == null) {
            return R.failed("请登录!");
        }
        List<String> settleDomainIds = new ArrayList<>();
        if (!Common.isNotNull(settleDomainId) && !SecurityUtils.isHaveAllOrg(ServiceNameConstants.CLIENT_ID_HR_B, user)){
            settleDomainIds = user.getSettleIdList();
            if (settleDomainIds == null || settleDomainIds.isEmpty()) {
                return R.failed(EmpBusinessConstants.noSettleDomainAuth);
            }
        }
        if (!Common.isNotNull(settleDomainId) && !Common.isNotNull(settleDomainIds)){
            return  R.failed(EmpBusinessConstants.selectSettleDomainOrCallManager);
        }
        return new R<>(tPaymentInfoService.getPaymentBusinessPageDetailByMonthAndAuth(month,settleDomainId,settleDomainIds));
    }

    /**
     * 查询派减的社保和公积金的分页数据
     * @Author fxj
     * @Date 2020-08-31
     * @param page
     * @param month
     * @param settleDomainId
     * @return
     **/
    @Operation(description = "查询派减的社保和公积金的分页数据")
    @GetMapping("/getSocialAndFundReduceInfo")
    public R<IPage<SocialAndFundReduceBusinessVo>> getSocialAndFundReduceInfo(Page<SocialAndFundReduceBusinessVo> page
			, @RequestParam String month, @RequestParam(value = "settleDomainId" , required = false) String settleDomainId) {
        if (!Common.isNotNull(month)){
            return R.failed("请传参月份！");
        }
        YifuUser user = SecurityUtils.getUser();
        if (user == null) {
            return R.failed("请登录!");
        }
        List<String> settleDomainIds = new ArrayList<>();
        boolean flag = !Common.isNotNull(settleDomainId) && !SecurityUtils.isHaveAllOrg(ServiceNameConstants.CLIENT_ID_HR_B, user);
        if (flag){
            settleDomainIds = user.getSettleIdList();
            if (settleDomainIds == null || settleDomainIds.isEmpty()) {
                return R.failed(EmpBusinessConstants.noSettleDomainAuth);
            }
        }
        if (!Common.isNotNull(settleDomainId) && !Common.isNotNull(settleDomainIds)){
            return  R.failed(EmpBusinessConstants.selectSettleDomainOrCallManager);
        }
        return new R<>(tPaymentInfoService.getSocialAndFundReduceInfo(page,month,settleDomainId,settleDomainIds));
    }
}
