/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpEducation;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpEducationService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpEducationSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 瓜子教育经历
 *
 * @author chenyx
 * @date 2025-06-13 15:19:04
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzempeducation")
@Tag(name = "瓜子教育经历管理")
public class TGzEmpEducationController {

	private final TGzEmpEducationService tGzEmpEducationService;


	/**
	 * 简单分页查询
	 *
	 * @param page            分页对象
	 * @param tGzEmpEducation 瓜子教育经历
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TGzEmpEducation>> getTGzEmpEducationPage(Page<TGzEmpEducation> page, TGzEmpEducationSearchVo tGzEmpEducation) {
		return new R<>(tGzEmpEducationService.getTGzEmpEducationPage(page, tGzEmpEducation));
	}

	/**
	 * 不分页查询
	 *
	 * @param tGzEmpEducation 瓜子教育经历
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TGzEmpEducation>> getTGzEmpEducationNoPage(@RequestBody TGzEmpEducationSearchVo tGzEmpEducation) {
		return R.ok(tGzEmpEducationService.noPageDiy(tGzEmpEducation));
	}

	/**
	 * 通过id查询瓜子教育经历
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzempeducation_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempeducation_get')")
	public R<TGzEmpEducation> getById(@PathVariable("id") String id) {
		return R.ok(tGzEmpEducationService.getById(id));
	}

}
