package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysHouseHoldInfoFailRes;
import com.yifu.cloud.plus.v1.yifu.social.service.SysHouseHoldInfoFailResService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 户与失败原因配置关联的控制器
 *
 * @author hgw
 * @date 2025-9-10 10:15:00
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/hufailres")
@Tag(name = "户与失败原因配置关联的控制器")
public class SysHouseHoldInfoFailResController {

	private final SysHouseHoldInfoFailResService sysHouseHoldInfoFailResService;

	/**
	 * 列表
	 * @return
	 */
	@Operation(description = "列表")
	@GetMapping("/getListByHuId")
	public R<List<SysHouseHoldInfoFailRes>> getListByHuId(@RequestParam String huId) {
		return new R<>(sysHouseHoldInfoFailResService.getListByHuId(huId));
	}
}