/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascHrField;
import com.yifu.cloud.plus.v1.yifu.archives.service.TFascHrFieldService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 法大大专业版皖信字段表
 *
 * @author hgw
 * @date 2025-09-30 16:29:27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tfaschrfield")
@Tag(name = "法大大专业版皖信字段表管理")
public class TFascHrFieldController {

	private final TFascHrFieldService tFascHrFieldService;

	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param tFascHrField 法大大专业版皖信字段表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TFascHrField>> getTFascHrFieldPage(Page<TFascHrField> page, TFascHrField tFascHrField) {
		return new R<>(tFascHrFieldService.getTFascHrFieldPage(page, tFascHrField));
	}

	/**
	 * 不分页查询
	 *
	 * @param tFascHrField 法大大专业版皖信字段表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TFascHrField>> getTFascHrFieldNoPage(@RequestBody TFascHrField tFascHrField) {
		return R.ok(tFascHrFieldService.noPageDiy(tFascHrField));
	}
}
