package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TAuditRecord;
import com.yifu.cloud.plus.v1.yifu.salary.service.TAuditRecordService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TAuditRecordSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Map;


/**
 * 审批记录表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tauditrecord" )
@Tag(name = "审批记录表管理")
public class TAuditRecordController {

    private final TAuditRecordService tAuditRecordService;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tApprovalRecord 审批记录表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAuditRecord>> getTApprovalRecordPage(Page<TAuditRecord> page, TAuditRecordSearchVo tApprovalRecord) {
        return  new R<>(tAuditRecordService.getTApprovalRecordPage(page,tApprovalRecord));
    }

	/**
	 * 通过实体id和审核类型查询所有的审核记录
	 * @param domainId  实体id
	 * @param auditType 审核类型 0不购买商险审核
	 * @return R<Map<String, Object>> key=auditInfo表示审批记录列表
	 **/
	@Operation(description = "通过实体id查询所有的审核记录")
	@GetMapping("/getAuditInfoByDomainIdAndAuditType")
	public R<Map<String, Object>> getAuditInfoByDomainIdAndAuditType(@RequestParam String domainId, @RequestParam String auditType) {
		if (Common.isEmpty(domainId) || Common.isEmpty(auditType)) {
			return R.failed("实体id或审核类型不能为空");
		}
		return tAuditRecordService.getAuditInfoByDomainIdAndAuditType(domainId, auditType);
	}

}
