/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * @author fxj
 * @Description 社保办理失败通知信息
 * @date 2025-10-15 14:50:53
 */
@Data
@TableName("t_social_alert_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保办理失败通知信息")
public class TSocialAlertInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 100)
	@Length(max = 100, message = "项目名称不能超过100个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 类型：0社保1公积金
	 */
	@ExcelAttribute(name = "类型：0社保1公积金", maxLength = 255)
	@Length(max = 255, message = "类型：0社保1公积金不能超过255个字符")
	@ExcelProperty("类型：0社保1公积金")
	@Schema(description = "类型：0社保1公积金")
	private String type;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证", maxLength = 30)
	@Length(max = 30, message = "员工身份证不能超过30个字符")
	@ExcelProperty("员工身份证")
	@Schema(description = "员工身份证")
	private String empIdcard;
	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因", maxLength = 200)
	@Length(max = 200, message = "失败原因不能超过200个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String reason;
	/**
	 * 接收人
	 */
	@ExcelAttribute(name = "接收人", maxLength = 36)
	@Length(max = 36, message = "接收人不能超过36个字符")
	@ExcelProperty("接收人")
	@Schema(description = "接收人")
	private String receiveUser;

	/**
	 * 办理事时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "办理事时间")
	private LocalDateTime handleTime;

	/**
	 * 户名称
	 */
	@ExcelAttribute(name = "户名称", maxLength = 20)
	@Length(max = 20, message = "户名称不能超过20个字符")
	@ExcelProperty("户名称")
	@Schema(description = "户名称")
	private String houseHoldName;

	/**
	 *  缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地-省",  maxLength = 32,isArea = true,needExport = true)
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省" )
	private String socialProvince;
	/**
	 *  缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市",    maxLength = 32, isArea = true, parentField = "socialProvince",needExport = true)
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市" )
	private String socialCity;
	/**
	 *  缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县",   maxLength = 32, isArea = true, parentField = "socialCity",needExport = true)
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县" )
	private String socialTown;

	/**
	 *  公积金缴纳地-省
	 */
	@ExcelAttribute(name = "公积金缴纳地-省",   maxLength = 32,  isArea = true, needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省" )
	private String fundProvince;
	/**
	 *  公积金缴纳地-市
	 */
	@ExcelAttribute(name = "公积金缴纳地-市",   maxLength = 32, isArea = true, parentField = "fundProvince",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市" )
	private String fundCity;
	/**
	 *  公积金缴纳地-县
	 */
	@ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32,  isArea = true, parentField = "fundCity",needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县" )
	private String fundTown;


	/**
	 *  派单ID
	 */
	@ExcelAttribute(name = "派单ID", maxLength = 32)
	@ExcelProperty("派单ID" )
	private String dispatchId;

	/**
	 *  申请人
	 */
	@ExcelAttribute(name = "申请人", maxLength = 32)
	@ExcelProperty("申请人" )
	private String applyName;

}
