/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 项目配置表主表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@ColumnWidth(30)
@Schema(description = "项目配置表主表")
public class TAutoMainRelExportVo implements Serializable {
	/**
	 * 项目名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String departName;
	/**
	 * 项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 服务状态：0正常 1停止服务 2冻结   （是否使用：0是 非0否）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "服务状态：0正常 1停止服务 2冻结")
	@ExcelProperty("是否可用")
	private String stopFlag;

	/**
	 * 前端客服
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String csUserName;

	/**
	 * 最新更新时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最新更新时间")
	@Schema(description = "最新更新时间")
	private Date ruleUpdateTime;
	/**
	 * 规则最新更新人
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最新更新操作人")
	@Schema(description = "规则最新更新人")
	private String ruleUpdatePerson;



}
