/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCustomerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
@Mapper
public interface TSettleDomainMapper extends BaseMapper<TSettleDomain> {

	IPage<TSettleDomain> getPage(Page<TSettleDomain> page, @Param("tSettleDomain") TSettleDomain tSettleDomain);

	IPage<SecondBelongVo> getTwoBlongPage(Page<TSettleDomain> page, @Param("tSettleDomain") TSettleDomain tSettleDomain);

	List<TSettleDomain> getPage(@Param("tSettleDomain") TSettleDomain tSettleDomain);

	/**
	 * 	分页获取项目名称缩小可见范围
	 *
	 * @author wzb
	 * @param page
	 * @param userId
	 * @param departName
	 * @param nameOrNo
	 * @param customerId
	 * @param flag
	 * @return {@link IPage< TSettleDomain>}
	 */
	IPage<TSettleDomain> getPagePerMission(Page<TSettleDomain> page, @Param("userId") String userId,@Param("departName") String departName,@Param("nameOrNo") String nameOrNo,@Param("customerId") String customerId, @Param("flag") String flag);

	IPage<IdNameNoVo> getUnitPage(Page<IdNameNoVo> page, @Param("idNameNoVo") IdNameNoVo idNameNoVo);
	/**
	 * @param departNo
	 * @Author: wangan
	 * @Date: 2019/10/18
	 * @Description: 通过id获取项目及单位部分信息
	 **/
	TSettleDomainSelectVo selectSettleDomainSelectVosById(@Param("departNo") String departNo);

	/**
	 * @param id 项目主键
	 * @Description: 通过id获取结算主体及单位部分信息
	 * @Author: hgw
	 * @Date: 2022/8/10 17:00
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo
	 **/
	TSettleDomainSelectVo getSettleDomainVoById(@Param("id") String id);
	TSettleDomainSelectVo getSettleDomainVoByNo(@Param("deptNo") String deptNo);

	/**
	 * 获取所有客户单位的项目信息
	 * @Author fxj
	 * @Date 2019-12-24
	 * @param
	 * @return
	 **/
	List<TSettleDomainSelectVo> selectAllSettleDomainSelectVos();
	/**
	 * @Author fxj
	 * @Description  通过项目编码获取客户单位的项目信息
	 * @Date 11:08 2022/7/20
	 * @Param
	 * @return
	**/
    List<ProjectSetInfoVo> getSetInfoByCodes(@Param(value = "codes") List<String> codes);

	List<TSettleDomain> getSettleInfoByCodes(@Param(value = "codes") List<String> codes);

	List<TSettleDomain> getOwnSettleDomainNoPage(@Param("userId") String userId, @Param("name") String name);

	IPage<TSettleDomainVo> getOwnSettleDomain(Page page, @Param("userId") String userId, @Param("name") String name);

	IPage<TCustomerInfo> getTCustomerInfoPageForB(Page page, @Param("tSettleDomain")TCustomerInfo tSettleDomain);

	IPage<TSettleDomainVo> getTSettleDomainPageB(Page page, @Param("tSettleDomain")TSettleDomainVo tSettleDomain);

	List<TCustomerInfo> getTCustomerInfoForB(@Param("ids")List<String> tSettleDomain);

	IPage<CustomerOwnerSelectVo> getCustomerOwnerPage(Page page,
													  @Param("customerName")String customerName,
													  @Param("userId")String userId);

	 void   changeIssueStatus(@Param("changeIssueStatusVo")ChangeIssueStatusVo changeIssueStatusVo);

    List<TSettleDomain> getAllInfoMap();

	List<String> getAllDeptByCustomerLoginName(@Param(value = "userLoginName") String userLoginName);

	List<ProjectCustomerServiceVo> getServiceInfoByCodes(@Param(value = "codes")List<String> deptNos);
}
