package com.yifu.cloud.plus.v1.business.dto.vacation;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @description: ImportVacationInfoDTO
 * @author: wangweiguo
 * @date: 2021/8/24
 */
@Setter
@Getter
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class ImportVacationInfoDTO implements Serializable {

    /**
     * 电信工号
     */
    @NotBlank(message = "电信工号不能为空")
    @Length(max = 20, message = "电信工号不能超过20个字符")
	@Schema(description = "电信工号")
	private String businessTelecomNumber;

    /**
     * 人员姓名
     */
    @Length(max = 20, message = "姓名不能超过20个字符")
	@Schema(description = "姓名")
	private String empName;

    /**
     * 所属部门部门名称
     */
	@Schema(description = "所属部门")
	@Length(max = 32, message = "所属部门名称不能超过32个字符")
    private String departName;

    /**
     * 假勤类型
     */
	@Schema(description = "假勤类型")
	@NotBlank(message = "假勤类型不能为空")
    @Length(max = 32, message = "假勤类型不能超过32个字符")
    private String vacationType;

    /**
     * 假勤事由
     */
	@Schema(description = "假勤事由")
	@Length(max = 200, message = "假勤事由不能超过200个字符")
    private String vacationReason;

    /**
     * 假勤开始时间
     */
	@Schema(description = "假勤开始时间")
	@NotNull(message = "假勤开始时间不能为空")
    private LocalDate vacationStartTime;

    /**
     * 假勤结束时间
     */
	@Schema(description = "假勤结束时间")
	@NotNull(message = "假勤结束时间不能为空")
    private LocalDate vacationEndTime;

    /**
     * 假勤时长
     */
	@Schema(description = "假勤时长")
	@NotNull(message = "假勤时长不能为空")
    @Digits(integer = 5, fraction = 1, message = "假勤时长整数部分不超过5位，小数部分不超过1位")
    @DecimalMin(value = "0.0", message = "假勤时长不能为负数")
    private BigDecimal vacationDuration;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}
