package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialAutoLog;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialAutoLogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 合同自动化企微日志表
 *
 * @author huych
 * @date 2025-10-20 20:03:58
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialautolog" )
@Tag(name = "合同自动化企微日志表管理")
public class TSocialAutoLogController {

    private final  TSocialAutoLogService tSocialAutoLogService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tSocialAutoLog 合同自动化企微日志表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TSocialAutoLog>> getTSocialAutoLogPage(Page<TSocialAutoLog> page, TSocialAutoLog tSocialAutoLog) {
        return  new R<>(tSocialAutoLogService.getTSocialAutoLogPage(page,tSocialAutoLog));
    }

    /**
     * 通过id查询合同自动化企微日志表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_tsocialautolog_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('social_tsocialautolog_get')" )
    public R<TSocialAutoLog> getById(@PathVariable("id" ) String id) {
        return R.ok(tSocialAutoLogService.getById(id));
    }

}
