/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysGuaziBankBranch;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;


/**
 * 瓜子银行支行信息
 *
 * @author chenyx
 * @date 2025-06-17 09:43:32
 */
public interface SysGuaziBankBranchService extends IService<SysGuaziBankBranch> {
	/**
	 * 瓜子银行支行信息简单分页查询
	 *
	 * @param sysGuaziBankBranch 瓜子银行支行信息
	 * @return IPage<SysGuaziBankBranch>
	 */
	IPage<SysGuaziBankBranch> getSysGuaziBankBranchPage(Page<SysGuaziBankBranch> page, SysGuaziBankBranch sysGuaziBankBranch);

	/**
	 * 拉取瓜子支行信息
	 * @return R
	 */
	R pushBankBranck(String startTime, String endTime, Integer pageNum);

}
