/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

/**
 * 法大大专业版公司信息表
 *
 * @author hgw
 * @date 2025-10-22 17:43:17
 */
@Data
@TableName("t_fasc_company")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大专业版公司信息表")
public class TFascCompany extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 公司主体
	 */
	@ExcelAttribute(name = "公司主体", maxLength = 100)
	@Length(max = 100, message = "公司主体不能超过100个字符")
	@ExcelProperty("公司主体")
	@Schema(description = "公司主体")
	private String companyName;
	/**
	 * APPID
	 */
	@ExcelAttribute(name = "APPID", maxLength = 100)
	@Length(max = 100, message = "APPID不能超过100个字符")
	@ExcelProperty("APPID")
	@Schema(description = "APPID")
	private String appId;
	/**
	 * AppSecret
	 */
	@ExcelAttribute(name = "AppSecret", maxLength = 100)
	@Length(max = 100, message = "AppSecret不能超过100个字符")
	@ExcelProperty("AppSecret")
	@Schema(description = "AppSecret")
	private String appSecret;
	/**
	 * AppUrl
	 */
	@ExcelAttribute(name = "AppUrl", maxLength = 100)
	@Length(max = 100, message = "AppUrl不能超过100个字符")
	@ExcelProperty("AppUrl")
	@Schema(description = "AppUrl")
	private String appUrl;
	/**
	 * openId
	 */
	@ExcelAttribute(name = "openId", maxLength = 100)
	@Length(max = 100, message = "openId不能超过100个字符")
	@ExcelProperty("openId")
	@Schema(description = "openId")
	private String openId;
	/**
	 * 场景码
	 */
	@ExcelAttribute(name = "场景码", maxLength = 100)
	@Length(max = 100, message = "场景码不能超过100个字符")
	@ExcelProperty("场景码")
	@Schema(description = "场景码")
	private String businessId;

}
