package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TRiskMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.vo.RiskMonitorPerVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TRiskMonitorSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TRiskMonitorVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 风险管控统计
 *
 * @author huych
 * @date 2024-09-25 10:01:06
 */
@Mapper
public interface TRiskMonitorMapper extends BaseMapper<TRiskMonitor> {
    /**
     * 风险管控统计简单分页查询
     * @param tRiskMonitor 风险管控统计
     * @return
     */
    IPage<TRiskMonitor> getTRiskMonitorPage(Page<TRiskMonitor> page, @Param("tRiskMonitor") TRiskMonitorSearchVo tRiskMonitor);

	/**
	 * 风险管控统计简单分页查询
	 * @param tRiskMonitor 风险管控统计
	 * @return
	 */
	long getTRiskMonitorExportCount(@Param("tRiskMonitor") TRiskMonitorSearchVo tRiskMonitor);

	/**
	 * 风险管控统计导出查询
	 * @param tRiskMonitor 风险管控统计
	 * @return
	 */
	List<TRiskMonitorVo> getRiskMonitorExportList(@Param("tRiskMonitor") TRiskMonitorSearchVo tRiskMonitor);

	/**
	 * 风险管控统计导出查询
	 * @return
	 */
	List<TRiskMonitor> selectRiskMonitorList();

	/**
	 * 查询风险占比
	 * @return
	 */
	RiskMonitorPerVo getTRiskMonitorPer(@Param("tRiskMonitor") TRiskMonitorSearchVo tRiskMonitor);

	/**
	 * 删除所有监控数据
	 * @return
	 */
	void deleteAllRiskMonitorInfo();
}
