/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSet;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCompleteMonitorSetSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
public interface TCompleteMonitorSetService extends IService<TCompleteMonitorSet> {
	/**
	 * 完整度监控配置简单分页查询
	 *
	 * @param tCompleteMonitorSet 完整度监控配置
	 * @return
	 */
	IPage<TCompleteMonitorSet> getTCompleteMonitorSetPage(Page<TCompleteMonitorSet> page, TCompleteMonitorSetSearchVo tCompleteMonitorSet);

	List<TCompleteMonitorSet> noPageDiy(TCompleteMonitorSetSearchVo searchVo);

	/**
	 * @Description: 获取在用的员工合同类型
	 * @Author: hgw
	 * @Date: 2025/2/27 16:19
	 * @return: java.lang.String
	 **/
	String getContractType();

	/**
	 * @Description: 新增或编辑
	 * @Author: hgw
	 * @Date: 2025/2/27 16:19
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> saveOrUpdateInfo(TCompleteMonitorSet tCompleteMonitorSet);


}
