package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.Map;

/**
 * @Author huyc
 * @Date 2022-07-18
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprUpmsProperties.class)
public class UpmsDaprUtils {

	@Autowired
	private DaprUpmsProperties daprUpmsProperties;

	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaVo> getAreaListR() {
		R<AreaVo> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaVo","", AreaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}
	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaMap> getAreaMapR() {
		R<AreaMap> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaMap","", AreaMap.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有用户数据
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	**/
	public R<AllUserNaVo> getAllUserName() {
		R<AllUserNaVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getAllUserName","", AllUserNaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取所有用户数据失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有用户数据
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	 **/
	public R<AllUserNaVo> getAllUserIds() {
		R<AllUserNaVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getAllUserIdDTO","", AllUserNaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取所有用户数据失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author fxj
	 * @Description 获取指定用户名对应用户IDs
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	 **/
	public R<SysUserListVo> getUserIdsByUserNames(String usernames) {
		R<SysUserListVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUserIdsByUserNames", usernames, SysUserListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户名对应用户IDs失败！");
		}
		return allUserVoR;
	}
	/**
	 * @Author fxj
	 * @Description 通过用户ID 获取 不在用的MVP系统的用户
	 * @Date 17:24 2025/3/12
	**/
	public R<SysUsersVo> getUserVoByUserIds(String userIds) {
		R<SysUsersVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUserVoByUserIds", userIds, SysUsersVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户IDS对应用户信息失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author hgw
	 * @Description 通过用户ID 获取 在用的MVP系统的用户
	 * @Date 2025-8-1 14:51:03
	**/
	public R<SysUsersVo> getInUseUserByIds(String userIds) {
		R<SysUsersVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId()
				,"/user/inner/getInUseUserByIds", userIds, SysUsersVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户IDS对应在用的用户信息失败！");
		}
		return allUserVoR;
	}

	public R<SysUser> getSimpleUser(String userId) {
		R<SysUser> userR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getSimpleUser",userId, SysUser.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(userR)){
			return R.failed("获取所有用户数据失败！");
		}
		return userR;
	}

	public R<SysUser> getSimpleUserByLoginName(String loginName) {
		R<SysUser> userR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getSimpleUserByLoginName",loginName, SysUser.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(userR)){
			return R.failed("获取所有用户数据失败！");
		}
		return userR;
	}

	public R<SysUserListVo> getUserByRoleIdForCrm(UserApprovalRoleVO userByApprovalRole) {
		R<SysUserListVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUser/getUserByRoleIdForCrm",userByApprovalRole, SysUserListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("查询流程配置审批角色对应的审批人失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author huyc
	 * @Description 判断部门是否属于分公司
	 * @Date 10:38 2025/1/20
	 * @Param
	 * @return
	 **/
	public R<Boolean> selectExitDeptCompany(String deptId) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/selectExitDeptCompany", deptId, Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 判断部门是否属于分公司
	 * @Date 10:38 2025/1/20
	 * @Param
	 * @return
	 **/
	public R<SysCspDeptVo> selectCspDeptByUserDeptId(SysCspDeptVo vo) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/selectInnerCspDeptByUserDeptId", vo, SysCspDeptVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * 获取瓜子和皖信的字典映射
	 * @author chenyx
	 * @date 2025-06-11 15:57:30
	 * @since 1.7.12
	 **/
	public R<Map<String, Map<String,String>>> getRelValueMapByOutDictType() {
		R<Map<String, Map<String,String>>> relDictMapR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/sysoutreldictitem/inner/getDictMap","", Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(relDictMapR)){
			return R.failed("获取瓜子和皖信的字典映射数据失败！");
		}
		return relDictMapR;
	}

	/**
	 * @param paramVo 用户IDList + 菜单Id
	 * @Description: 判断用户的角色是否有菜单
	 * @Author: hgw
	 * @Date: 2025/9/4 16:09
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo>
	 **/
	public R<KeyValueReturnVo> judgeMenuByUserIdAndMenuId(ListAndStringVo paramVo) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId()
				,"/user/inner/judgeDispatchAudit", paramVo, KeyValueReturnVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @param paramVo 用户IDList + 菜单Id
	 * @Description: 判断用户的权限（用户拼接用户组）是否有菜单
	 * @Author: hgw
	 * @Date: 2025/9/4 16:09
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo>
	 **/
	public R<KeyValueReturnVo> judgeDiyAuthMenuByUserId(ListAndStringVo paramVo) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId()
				,"/user/inner/judgeDiyAuthMenuByUserId", paramVo, KeyValueReturnVo.class, SecurityConstants.FROM_IN);
	}

}
