package com.yifu.cloud.plus.v1.ekp.controller;

import com.alibaba.fastjson.JSONObject;
import com.yifu.cloud.plus.v1.ekp.service.EkpSocialInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptContractInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialStatusUpdateVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushSocialParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;


/**
 * 社保明细推送
 * @author huyc
 * @date 2024-02-28 17:01:22
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpSocialPush" )
@Tag(name = "社保明细推送")
public class TEkpSocialInfoController {

	private final EkpSocialInfoService socialInfoService;

	/**
	 * @param unPushList
	 * @Description: 推送社保明细数据
	 * @Author: huyc
	 * @Date: 2024/2/29
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/pushSocialInfoToEkp")
	public EkpSocialPushInfoVo pushSocialInfoToEkp(@RequestBody List<EkpPushSocialParam> unPushList) {
		return socialInfoService.pushSocialInfoToEkp(unPushList);
	}


	/**
	 * 修改项目表--EKP调用接口
	 * @author  hyc
	 * @param jsonStr 社保订单明细
	 * @return R
	 */
	@Operation(summary = "更新社保明细状态--EKP调用接口", description = "更新社保明细状态--EKP调用接口")
	@SysLog("更新社保明细状态--EKP调用接口")
	@PostMapping("/updateScoialStatus")
	public R updateScoialStatus(@RequestBody String jsonStr) {
		try {
			String json = jsonStr.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
			jsonStr = URLDecoder.decode(json, CommonConstants.UTF8).replace("=", "");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		List<EkpSocialStatusUpdateVo> list= JSONObject.parseArray(jsonStr, EkpSocialStatusUpdateVo.class);
		return socialInfoService.updateScoialStatus(list);
	}

	/**
	 * @param vo
	 * @Description: 根据项目编码查询项目信息
	 * @Author: huyc
	 * @Date: 2025/6/18
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/selectContractInfoByDetptNo")
	public EkpDeptContractInfoVo selectContractInfoInnerByDetptNo(@RequestBody EkpDeptContractInfoVo vo) {
		return socialInfoService.selectContractInfoByDetptNo(vo);
	}

	/**
	 * @param vo
	 * @Description: 根据项目编码查询项目信息
	 * @Author: huyc
	 * @Date: 2025/6/18
	 * @return:
	 **/
	@PostMapping("/selectContractInfoByDetptNo")
	public EkpDeptContractInfoVo selectContractInfoByDetptNo(@RequestBody EkpDeptContractInfoVo vo) {
		return socialInfoService.selectContractInfoByDetptNo(vo);
	}
}
