package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Data
public class TEmployeeInsurancePreSearchVo extends TEmployeeInsurancePre {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	private List<String> idList;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;

	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;


	@Schema(description =  "处理状态数组")
	@TableField(exist = false)
	private List<String> statusList;

	@Schema(description =  "项目权限数组")
	@TableField(exist = false)
	private List<String> deptNoList;

	@Schema(description =  "列表类型 1 待办 2监控 3入职确认信息")
	private String type;

	@Schema(description =  "入离职开始时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeStart;

	@Schema(description =  "入离职截止时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeEnd;

	@Schema(description =  "登记开始时间")
	@TableField(exist = false)
	private LocalDateTime registTimeStart;

	@Schema(description =  "登记截止时间")
	@TableField(exist = false)
	private LocalDateTime registTimeEnd;

}
