package com.yifu.cloud.plus.v1.permission.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.permission.mapper.SysUserPermissionMapper;
import com.yifu.cloud.plus.v1.permission.service.SysUserInfoService;
import com.yifu.cloud.plus.v1.permission.service.SysUserPermissionService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserPermission;
import com.yifu.cloud.plus.v1.yifu.permission.vo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Log4j2
@Service
@RequiredArgsConstructor
public class SysUserPermissionServiceImpl extends ServiceImpl<SysUserPermissionMapper, SysUserPermission> implements SysUserPermissionService {

	@Autowired
	private SysUserInfoService userInfoService;

	/**
	 * 新权限-用户权限表简单分页查询
	 *
	 * @param sysUserPermission 新权限-用户权限表
	 * @return
	 */
	@Override
	public IPage<SysUserPermission> getSysUserPermissionPage(Page<SysUserPermission> page, SysUserPermissionSearchVo sysUserPermission) {
		return baseMapper.getSysUserPermissionPage(page, sysUserPermission);
	}

	@Override
	public R savePermission(SysUserPermission sysUserPermission) {
		YifuUser user = SecurityUtils.getUser();
		//非管理员判断是否包含此权限维度
		SysUserPermission permission;
		if (Common.isNotNull(user.getId()) && CommonConstants.ONE_STRING.equals(user.getSystemFlag())) {
			permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
					.eq(SysUserPermission::getPermissionStatus, CommonConstants.ZERO_STRING)
					.eq(SysUserPermission::getEmpLoginName, user.getUsername())
					.eq(SysUserPermission::getCode,sysUserPermission.getCode()).last(CommonConstants.LAST_ONE_SQL));
			if (Common.isEmpty(permission)) {
				return R.failed("操作人仅可对本账号有权限的数据新增账号");
			}
		}
		if (CommonConstants.SIX_STRING.equals(sysUserPermission.getPermissionType())
				|| CommonConstants.SEVEN_STRING.equals(sysUserPermission.getPermissionType())
				|| CommonConstants.TEN_STRING.equals(sysUserPermission.getPermissionType())
				|| CommonConstants.TWELVE_STRING.equals(sysUserPermission.getPermissionType())
				|| CommonConstants.THIRTEEN_STRING.equals(sysUserPermission.getPermissionType())
				|| CommonConstants.FOURTEEN_STRING.equals(sysUserPermission.getPermissionType())) {
			permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
					.eq(SysUserPermission::getEmpLoginName, sysUserPermission.getEmpLoginName())
					.eq(SysUserPermission::getPermissionType, sysUserPermission.getPermissionType())
					.eq(SysUserPermission::getName,sysUserPermission.getName()).last(CommonConstants.LAST_ONE_SQL));
			if (Common.isNotNull(permission)) {
				return R.failed("系统中已经存在对应名称的权限类型");
			}
		} else {
			permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
					.eq(SysUserPermission::getEmpLoginName, sysUserPermission.getEmpLoginName())
					.eq(SysUserPermission::getPermissionType, sysUserPermission.getPermissionType())
					.eq(SysUserPermission::getCode,sysUserPermission.getCode()).last(CommonConstants.LAST_ONE_SQL));
			if (Common.isNotNull(permission)) {
				return R.failed("系统中已经存在对应编码的权限类型");
			}
		}
		this.save(sysUserPermission);
		return R.ok();
	}

	/**
	 * 新权限-用户权限表批量导出
	 *
	 * @param searchVo 新权限-用户权限表
	 * @return
	 */
	@Override
	public void listExport(HttpServletResponse response, SysUserPermissionSearchVo searchVo) {
		String fileName = "数据权限表批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<SysUserPermissionExportVo> list = new ArrayList<>();
		long count = baseMapper.userSelectCount(searchVo);
		try (ServletOutputStream out = response.getOutputStream()) {
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName, CommonConstants.UTF8));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, SysUserPermissionExportVo.class).build();
			int index = 0;
			if (count > CommonConstants.ZERO_INT) {
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.userSelectList(searchVo);
					if (Common.isNotNull(list)) {
						WriteSheet writeSheet = EasyExcel.writerSheet("数据权限表" + index).build();
						excelWriter.write(list, writeSheet);
						index++;
					}
					if (Common.isNotNull(list)) {
						list.clear();
					}
				}
			} else {
				WriteSheet writeSheet = EasyExcel.writerSheet("数据权限表" + index).build();
				excelWriter.write(list, writeSheet);
			}
			if (Common.isNotNull(list)) {
				list.clear();
			}
			excelWriter.finish();
		} catch (Exception e) {
			log.error("执行异常", e);
		}
	}

	@Override
	public IPage<SysUserDeptVo> getNameCodePage(Page<SysUserDeptVo> page, SysUserDeptVo searchVo) {
		if (Common.isNotNull(searchVo) && Common.isNotNull(searchVo.getType())) {
			YifuUser user = SecurityUtils.getUser();
			IPage<SysUserDeptVo> iPage;
			//客户权限
			if (CommonConstants.ONE_STRING.equals(searchVo.getType())) {
				iPage = baseMapper.selectUnitVO(page,searchVo.getName());
			} else if (CommonConstants.TWO_STRING.equals(searchVo.getType())) {
				//商机权限
				iPage = baseMapper.selectBusinessVO(page, searchVo.getName());
			} else if (CommonConstants.THREE_STRING.equals(searchVo.getType())) {
				//报价单权限
				iPage = baseMapper.selectQuotationVO(page, searchVo.getName());
			} else if (CommonConstants.FOUR_STRING.equals(searchVo.getType())) {
				//合同权限
				if (Common.isNotNull(user.getId()) && CommonConstants.ZERO_STRING.equals(user.getSystemFlag())) {
					iPage = baseMapper.selectContractVO(page, searchVo.getName());
				} else {
					iPage = baseMapper.selectContractSimpleVO(page, user.getUsername(),searchVo.getName(),searchVo.getType());
				}
			} else if (CommonConstants.EIGHT_STRING.equals(searchVo.getType()) || CommonConstants.NINE_STRING.equals(searchVo.getType())) {
				//部门&&收入归属权限
				iPage = baseMapper.selectDeptVO(page, searchVo.getName());
			} else if (CommonConstants.TEN_STRING.equals(searchVo.getType()) ) {
				//二级指标归属权限
				iPage = baseMapper.selectTwoGsVO(page, searchVo.getName());
			} else if (CommonConstants.TWELVE_STRING.equals(searchVo.getType())
					||CommonConstants.THIRTEEN_STRING.equals(searchVo.getType())
					||CommonConstants.FOURTEEN_STRING.equals(searchVo.getType()) ) {
				//税务主体|事业部|事业部条线
				iPage = baseMapper.selectTaxVO(page, searchVo.getName());
			} else {
				//项目权限
				if (Common.isNotNull(user.getId()) && CommonConstants.ZERO_STRING.equals(user.getSystemFlag())) {
					iPage = baseMapper.selectSettleVO(page, searchVo.getName());
				} else {
					iPage = baseMapper.selectContractSimpleVO(page, user.getUsername(),searchVo.getName(),searchVo.getType());
				}
			}
			return iPage;
		}
		return null;
	}

	@Override
	public List<SysDictVo> selectDictByType(String type) {
		YifuUser user = SecurityUtils.getUser();
		if ("permission".equals(type) && Common.isNotNull(user.getId()) && CommonConstants.ONE_STRING.equals(user.getSystemFlag())) {
			return baseMapper.selectDictByTypeOne(type,CommonConstants.ZERO_STRING);
		} else {
			return baseMapper.selectDictByType(type);
		}
	}

	@Override
	public R<List<ErrorMessage>> importDiy(InputStream inputStream) {
		List<ErrorMessage> errorMessageList = new ArrayList<>();
		ExcelUtil<SysUserPermissionVo> util1 = new ExcelUtil<>(SysUserPermissionVo.class);

		//查询权限类型字典
		List<SysDictVo> typeList = baseMapper.selectDictByType("permission");
		Map<String, String> typeMap = typeList.stream().collect(Collectors.toMap(SysDictVo::getName, SysDictVo::getId));
		//查询所有用户的信息
		List<SysUserInfo> userInfoList = userInfoService.list(Wrappers.<SysUserInfo>query().lambda()
						.eq(SysUserInfo::getStatus, CommonConstants.ZERO_INT));
		//登录账号+维度+唯一标识唯一
		Map<String,String> uniqueMap = new HashMap<>();
		// 写法2：
		// 匿名内部类 不用额外写一个DemoDataListener
		// 这里 需要指定读用哪个class去读，然后读取第一个sheet 文件流会自动关闭
		try {
			EasyExcel.read(inputStream, SysUserPermissionVo.class, new ReadListener<SysUserPermissionVo>() {
				/**
				 * 单次缓存的数据量
				 */
				public static final int BATCH_COUNT = CommonConstants.BATCH_COUNT;
				/**
				 *临时存储
				 */
				private List<SysUserPermissionVo> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

				@Override
				public void invoke(SysUserPermissionVo data, AnalysisContext context) {
					ReadRowHolder readRowHolder = context.readRowHolder();
					Integer rowIndex = readRowHolder.getRowIndex();
					data.setRowIndex(rowIndex + 1);
					ErrorMessage errorMessage = util1.checkEntity(data, data.getRowIndex());
					if (Common.isNotNull(errorMessage)) {
						errorMessage.setData(data);
						errorMessageList.add(errorMessage);
					} else {
						cachedDataList.add(data);
					}
					if (cachedDataList.size() >= BATCH_COUNT) {
						saveData();
						// 存储完成清理 list
						cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
					}
				}

				@Override
				public void doAfterAllAnalysed(AnalysisContext context) {
					saveData();
				}

				/**
				 * 加上存储数据库
				 */
				private void saveData() {
					log.info("{}条数据，开始存储数据库！", cachedDataList.size());
					importSysUserPermission(cachedDataList, errorMessageList,typeMap,userInfoList,uniqueMap);
					log.info("存储数据库成功！");
				}
			}).sheet().doRead();
		} catch (Exception e) {
			log.error(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR, e);
			return R.failed(CommonConstants.IMPORT_DATA_ANALYSIS_ERROR);
		}
		return R.ok(errorMessageList);
	}

	private void importSysUserPermission(List<SysUserPermissionVo> excelVOList, List<ErrorMessage> errorMessageList,
										 Map<String,String> typeMap,List<SysUserInfo> userInfoList,Map<String,String> uniqueMap) {

		YifuUser user = SecurityUtils.getUser();
		SysUserPermission permission;
		List<SysUserInfo> userInfo;
		String domainId;

		try {
			// 执行数据插入操作 组装
			for (int i = 0; i < excelVOList.size(); i++) {
				SysUserPermissionVo excel = excelVOList.get(i);
				//登录名校验
				userInfo = userInfoList.stream().filter(e -> excel.getEmpLoginName().equals(e.getFdLoginName())).collect(Collectors.toList());
				if (userInfo.isEmpty()) {
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "登录名填写错误，请核实", excel));
					continue;
				}

				//从用户表中获取部门和用户名
				SysUserInfo sysUserInfo = userInfo.get(0);
				excel.setEmpDept(sysUserInfo.getFdDeptName());
				excel.setEmpName(sysUserInfo.getFdName());
				excel.setUserId(sysUserInfo.getFdId());
				SysUserPermission insert = new SysUserPermission();
				BeanUtil.copyProperties(excel, insert);
				//判断表格权限类型是否正确
				if (typeMap.isEmpty()) {
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "获取权限类型字典值异常", excel));
					continue;
				}
				//判断表格权限类型是否正确
				if (null == typeMap.get(excel.getPermissionType())) {
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "权限类型填写错误，请核实", excel));
					continue;
				} else {
					insert.setPermissionType(typeMap.get(excel.getPermissionType()));
				}

				//部门权限的时候是否含下级必填
				if (CommonConstants.EIGHT_STRING.equals(insert.getPermissionType()) && Common.isEmpty(excel.getIsContains())) {
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "权限类型为部门权限时，是否含下级部门必填", excel));
					continue;
				}

				//登录账号+维度+唯一标识唯一
				StringBuilder flag = new StringBuilder();
				flag.append(excel.getEmpLoginName());
				flag.append("_");
				flag.append(insert.getPermissionType());
				flag.append("_");
				if (CommonConstants.SIX_STRING.equals(insert.getPermissionType()) ||
						CommonConstants.SEVEN_STRING.equals(insert.getPermissionType()) ||
						CommonConstants.TEN_STRING.equals(insert.getPermissionType())
						|| CommonConstants.TWELVE_STRING.equals(insert.getPermissionType())
						|| CommonConstants.THIRTEEN_STRING.equals(insert.getPermissionType())
						|| CommonConstants.FOURTEEN_STRING.equals(insert.getPermissionType())) {
					flag.append(excel.getName());
				} else {
					flag.append(excel.getCode());
				}
				if (null != uniqueMap.get(flag.toString())) {
					errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "导表中已经存在该登录名对应的权限类型的名称或者编码！", excel));
					continue;
				} else {
					uniqueMap.put(flag.toString(), CommonConstants.ONE_STRING);
				}

				//BU、条线、二级指标归属的时候用名称判断，其他用编码判断
				//判断此登录名是否已经存在此权限维度
				if (CommonConstants.SIX_STRING.equals(insert.getPermissionType())
						|| CommonConstants.SEVEN_STRING.equals(insert.getPermissionType())
						|| CommonConstants.TEN_STRING.equals(insert.getPermissionType())
						|| CommonConstants.TWELVE_STRING.equals(insert.getPermissionType())
						|| CommonConstants.THIRTEEN_STRING.equals(insert.getPermissionType())
						|| CommonConstants.FOURTEEN_STRING.equals(insert.getPermissionType())) {
					//判断对应维度的名称是否存在
					Integer count;
					if (CommonConstants.SIX_STRING.equals(insert.getPermissionType())) {
						count = baseMapper.selectDictByName(excel.getName(), "bu");
					} else if (CommonConstants.TEN_STRING.equals(insert.getPermissionType())) {
						count = baseMapper.selectTwoGsCount(excel.getName());
					}  else if (CommonConstants.TWELVE_STRING.equals(insert.getPermissionType())) {
						count = baseMapper.selectTaxCount(excel.getName());
					}  else if (CommonConstants.THIRTEEN_STRING.equals(insert.getPermissionType())) {
						count = baseMapper.selectDivitionCount(excel.getName());
					}  else if (CommonConstants.FOURTEEN_STRING.equals(insert.getPermissionType())) {
						count = baseMapper.selectDivitionLineCount(excel.getName());
					} else {
						count = baseMapper.selectDictByName(excel.getName(), "line");
					}
					if (count < 1) {
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "不存在对应权限类型的名称信息", excel));
						continue;
					}
					permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
							.eq(SysUserPermission::getEmpLoginName, excel.getEmpLoginName())
							.eq(SysUserPermission::getPermissionType, insert.getPermissionType())
							.eq(SysUserPermission::getName, excel.getName()).last(CommonConstants.LAST_ONE_SQL));
					if (Common.isNotNull(permission)) {
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "系统中已经存在该用户对应的名称的权限类型", excel));
						continue;
					}
					insert.setCode(null);
				} else {
					//判断对应维度的编码是否存在
					Integer count = this.checkExit(insert.getPermissionType(), excel.getCode());
					if (count < 1) {
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "不存在对应权限类型的编码信息", excel));
						continue;
					}
					permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
							.eq(SysUserPermission::getEmpLoginName, excel.getEmpLoginName())
							.eq(SysUserPermission::getPermissionType, insert.getPermissionType())
							.eq(SysUserPermission::getCode, excel.getCode()).last(CommonConstants.LAST_ONE_SQL));
					if (Common.isNotNull(permission)) {
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "系统中已经存在该用户对应的编码的权限类型", excel));
						continue;
					}
				}

				//非管理员的用户只能导入合同和项目权限维度的数据且只有自己有权限的维度才可导入
				//当登录人不是管理员时根据导表登录名查询权限数据
				if (Common.isNotNull(user.getId()) && CommonConstants.ONE_STRING.equals(user.getSystemFlag())) {
					permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
							.eq(SysUserPermission::getPermissionStatus, CommonConstants.ZERO_STRING)
							.eq(SysUserPermission::getEmpLoginName, user.getUsername())
							.eq(SysUserPermission::getPermissionType, insert.getPermissionType())
							.eq(SysUserPermission::getCode, excel.getCode()).last(CommonConstants.LAST_ONE_SQL));
					if (Common.isEmpty(permission)) {
						errorMessageList.add(new ErrorMessage(excel.getRowIndex(), "操作人仅可对本账号有权限的数据新增账号", excel));
						continue;
					}
				}
				//项目权限的时候赋值项目id
				if (CommonConstants.EIGHT_STRING.equals(insert.getPermissionType()) ||
						CommonConstants.NINE_STRING.equals(insert.getPermissionType())) {
					domainId = baseMapper.selectSettleByCode(insert.getCode());
					insert.setDomainId(domainId);
				}
				if (!CommonConstants.EIGHT_STRING.equals(insert.getPermissionType())) {
					insert.setIsContains(null);
				}
				// 插入数据
				insertExcel(insert);
			}
		} catch (Exception e) {
			log.error("用户权限表导入异常：" + e);
		}
	}

	/**
	 * 插入excel bad record
	 */
	private void insertExcel(SysUserPermission insert) {
		//转化是否含下级
		if (Common.isNotNull(insert.getIsContains())) {
			if (CommonConstants.IS_TRUE.equals(insert.getIsContains())) {
				insert.setIsContains(CommonConstants.ZERO_STRING);
			} else {
				insert.setIsContains(CommonConstants.ONE_STRING);
			}
		}
		this.save(insert);
	}

	private Integer checkExit(String type,String name) {
		//客户权限
		if (CommonConstants.ONE_STRING.equals(type)) {
			return baseMapper.selectUnitCount(name);
		} else if (CommonConstants.TWO_STRING.equals(type)) {
			//商机权限
			return baseMapper.selectBusinessCount(name);
		} else if (CommonConstants.THREE_STRING.equals(type)) {
			//报价单权限
			return baseMapper.selectQuotationCount(name);
		} else if (CommonConstants.FOUR_STRING.equals(type)) {
			//合同权限
			return baseMapper.selectContractCount(name);
		} else if (CommonConstants.EIGHT_STRING.equals(type) || CommonConstants.NINE_STRING.equals(type)) {
			//部门&&收入归属权限
			return baseMapper.selectDeptCount(name);
		} else {
			//项目权限
			return baseMapper.selectSettleCount(name);
		}
	}

	@Override
	public R<String> autoCreateAuth(IdTypeEkpVo vo) {
		String fdId = vo.getFdId();
		String type = vo.getType();

		// 先找到表（客户、项目、项目立项等），找到创建人、服务团队；
		// 组装实体类，查重，新增或更新
		List<SysUserPermission> list;

		// 1客户；2商机；3报价单；4合同；5项目；
		String deleteType = CommonConstants.ONE_STRING;
		switch (type) {
			case "客户":
				deleteType = CommonConstants.dingleDigitStrArray[1];
				list = baseMapper.getUserPermissionByAutoCreateKH(fdId); break;
			case "商机":
				deleteType = CommonConstants.dingleDigitStrArray[2];
				list = baseMapper.getUserPermissionByAutoCreateSJ(fdId); break;
			case "报价单":
				deleteType = CommonConstants.dingleDigitStrArray[3];
				list = baseMapper.getUserPermissionByAutoCreateBJD(fdId); break;
			case "合同":
				deleteType = CommonConstants.dingleDigitStrArray[4];
				list = baseMapper.getUserPermissionByAutoCreateHT(fdId); break;
			case "合同变更":
				deleteType = CommonConstants.dingleDigitStrArray[4];
				list = baseMapper.getUserPermissionByAutoCreateHTBG(fdId); break;
			case "项目":
				deleteType = CommonConstants.dingleDigitStrArray[5];
				list = baseMapper.getUserPermissionByAutoCreateXM(fdId); break;
			case "项目变更": //项目服务团队及项目负责人变更 fxj 20250410 V1.7.9
				deleteType = CommonConstants.dingleDigitStrArray[5];
				//list = baseMapper.getUserPermissionByAutoCreateXMBG(fdId);
				List<SysUserPermission> temp;
				//变更后项目负责人
				temp = baseMapper.getUserPermissionByAutoCreateXMBG1(fdId);
				list = new ArrayList<>();
				//无变更取值变更前项目负责人
				if (Common.isEmpty(temp)){
					temp = baseMapper.getUserPermissionByAutoCreateXMBG2(fdId);
				}
				if (Common.isNotNull(temp)){
					list.addAll(temp);
				}
				//变更后服务团队
				temp = baseMapper.getUserPermissionByAutoCreateXMBG3(fdId);
				//无变更取值变更前服务团队
				if (Common.isEmpty(temp)){
					temp = baseMapper.getUserPermissionByAutoCreateXMBG4(fdId);
				}
				if (Common.isNotNull(temp)){
					list.addAll(temp);
				}
				break;
			default:
				list = new ArrayList<>();
		}
		if (list != null && !list.isEmpty()) {
			if (Common.isNotNull(list.get(0).getCode())) {
				baseMapper.deleteUserPermissionByIdAndType(list.get(0).getCode(), deleteType);
			}

			for (SysUserPermission sysUserPermission : list) {
				SysUserPermission permission = this.getOne(Wrappers.<SysUserPermission>query().lambda()
						.eq(SysUserPermission::getDeleteFlag, CommonConstants.ONE_STRING)
						.eq(SysUserPermission::getEmpLoginName, sysUserPermission.getEmpLoginName())
						.eq(SysUserPermission::getPermissionType, sysUserPermission.getPermissionType())
						.eq(SysUserPermission::getCode, sysUserPermission.getCode()).last(CommonConstants.LAST_ONE_SQL));
				if (permission == null || Common.isEmpty(permission) || Common.isEmpty(permission.getId())) {
					this.save(sysUserPermission);
				}
			}
		} else {
			String code = baseMapper.selectCodeByFdId(fdId);
			if (Common.isNotNull(code)) {
				baseMapper.deleteUserPermissionByIdAndType(code, deleteType);
			}
		}
		return R.ok();
	}

}
