/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysBaseSetInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.SysBaseSetFundExportVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.SysBaseSetSocialExportVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 基数设置表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
@Mapper
public interface SysBaseSetInfoMapper extends BaseMapper<SysBaseSetInfo> {
	/**
	 * 基数设置表简单分页查询
	 *
	 * @param sysBaseSetInfo 基数设置表
	 * @return
	 */
	IPage<SysBaseSetInfo> getSysBaseSetInfoPage(Page<SysBaseSetInfo> page, @Param("sysBaseSetInfo") SysBaseSetInfo sysBaseSetInfo);

	List<SysBaseSetSocialExportVo> noPageSocialDiy(@Param("sysBaseSetInfo") SysBaseSetInfo sysBaseSetInfo);

	List<SysBaseSetFundExportVo> noPageFundDiy(@Param("sysBaseSetInfo") SysBaseSetInfo sysBaseSetInfo);

	List<SysBaseSetInfo> getAllByEntity(@Param("sysBaseSetInfo")SysBaseSetInfo sysBaseSetInfo);

	/**
	 * 获取基数配置
	 * @Author fxj
	 * @Date 2019-10-08
	 * @param sysBaseSetInfo
	 * @return
	 **/
	List<SysBaseSetInfo> getSysBaseSetInfoNoPage(@Param("sysBaseSetInfo")SysBaseSetInfo sysBaseSetInfo);


	/**
	 * @Author fxj
	 * @Description 获取对应户名称的公积金基数信息
	 * @Date 17:27 2022/7/19
	 * @Param
	 * @return
	**/
	List<SysBaseSetInfo> getFundBaseSet(@Param("fundHolds")List<String> fundHolds);

	/**
	 * @param sysBaseSetInfo
	 * @Description: 编辑时查询有没有已存在的配置
	 * @Author: hgw
	 * @Date: 2023/2/15 18:15
	 * @return: int
	 **/
	int getCountByEdit(@Param("sysBaseSetInfo") SysBaseSetInfo sysBaseSetInfo);
}
