/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 入职确认信息变更日志明细表
 *
 * @author hgw
 * @date 2025-04-07 15:35:05
 */
@Data
@TableName("t_employee_pre_log_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入职确认信息变更日志明细表")
public class TEmployeePreLogDetail extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 类型：1档案；2商险
	 */
	@ExcelAttribute(name = "类型：1档案；2商险3合同", maxLength = 1)
	@Length(max = 1, message = "类型：1档案；2商险3合同不能超过1个字符")
	@ExcelProperty("类型：1档案；2商险3合同")
	@Schema(description = "类型：1档案；2商险 3合同")
	private String type;
	/**
	 * 入职确认信息表ID
	 */
	@ExcelAttribute(name = "入职确认信息表ID", isNotEmpty = true, errorInfo = "入职确认信息表ID不能为空", maxLength = 32)
	@NotBlank(message = "入职确认信息表ID不能为空")
	@Length(max = 32, message = "入职确认信息表ID不能超过32个字符")
	@ExcelProperty("入职确认信息表ID")
	@Schema(description = "入职确认信息表ID")
	private String preId;
	/**
	 * 入职日志ID
	 */
	@ExcelAttribute(name = "入职日志ID", isNotEmpty = true, errorInfo = "入职日志ID不能为空", maxLength = 32)
	@NotBlank(message = "入职日志ID不能为空")
	@Length(max = 32, message = "入职日志ID不能超过32个字符")
	@ExcelProperty("入职日志ID")
	@Schema(description = "入职日志ID")
	private String preLogId;

	/**
	 * 原来的信息
	 */
	@ExcelAttribute(name = "原来的信息", isNotEmpty = true, errorInfo = "原来的信息不能为空")
	@NotBlank(message = "原来的信息不能为空")
	@ExcelProperty("原来的信息")
	@Schema(description = "原来的信息")
	private String oldInfo;
	/**
	 * 新的信息
	 */
	@ExcelAttribute(name = "新的信息", isNotEmpty = true, errorInfo = "新的信息不能为空")
	@NotBlank(message = "新的信息不能为空")
	@ExcelProperty("新的信息")
	@Schema(description = "新的信息")
	private String newInfo;
	/**
	 * 差异的信息(属性名称，逗号隔开)
	 */
	@ExcelAttribute(name = "差异的信息(属性名称，逗号隔开)")
	@ExcelProperty("差异的信息(属性名称，逗号隔开)")
	@Schema(description = "差异的信息(属性名称，逗号隔开)")
	private String differenceInfo;
	/**
	 * 修改类型：1新增；2修改；3删除
	 */
	@ExcelAttribute(name = "修改类型：1新增；2修改；3删除", maxLength = 1)
	@Length(max = 1, message = "修改类型：1新增；2修改；3删除不能超过1个字符")
	@ExcelProperty("修改类型：1新增；2修改；3删除")
	@Schema(description = "修改类型：1新增；2修改；3删除")
	private String modelType;

}
