/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 社保购买规则主表
 *
 * @author fxj
 * @date 2025-10-09 11:13:18
 */
@Data
public class TAutoSocialRuleInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键ID 不能为空")
	@Length(max = 32, message = "主键ID 不能超过32 个字符")
	@ExcelAttribute(name = "主键ID", isNotEmpty = true, errorInfo = "主键ID 不能为空", maxLength = 32)
	@Schema(description = "主键ID")
	@ExcelProperty("主键ID")
	private String id;
	/**
	 * 项目配置ID
	 */
	@NotBlank(message = "项目配置ID 不能为空")
	@Length(max = 32, message = "项目配置ID 不能超过32 个字符")
	@ExcelAttribute(name = "项目配置ID", isNotEmpty = true, errorInfo = "项目配置ID 不能为空", maxLength = 32)
	@Schema(description = "项目配置ID")
	@ExcelProperty("项目配置ID")
	private String mainId;
	/**
	 * 是否自动触发派增(字典：0自动触发派增,1：手动派增)
	 */
	@NotBlank(message = "是否自动触发派增(字典：0自动触发派增,1：手动派增) 不能为空")
	@Length(max = 1, message = "是否自动触发派增(字典：0自动触发派增,1：手动派增) 不能超过1 个字符")
	@ExcelAttribute(name = "是否自动触发派增(字典：0自动触发派增,1：手动派增)", isNotEmpty = true, errorInfo = "是否自动触发派增(字典：0自动触发派增,1：手动派增) 不能为空", maxLength = 1)
	@Schema(description = "是否自动触发派增(字典：0自动触发派增,1：手动派增)")
	@ExcelProperty("是否自动触发派增(字典：0自动触发派增,1：手动派增)")
	private String autoFlag;
	/**
	 * 派单发起时间(字典::0：入职满1个月...入职满6个月)
	 */
	@Length(max = 2, message = "派单发起时间(字典::0：入职满1个月...入职满6个月) 不能超过2 个字符")
	@ExcelAttribute(name = "派单发起时间(字典::0：入职满1个月...入职满6个月)", maxLength = 2)
	@Schema(description = "派单发起时间(字典::0：入职满1个月...入职满6个月)")
	@ExcelProperty("派单发起时间(字典::0：入职满1个月...入职满6个月)")
	private String startPeriod;
	/**
	 * 派单发起具体时间字典：0：15:20
	 */
	@Length(max = 10, message = "派单发起具体时间字典：0：15:20 不能超过10 个字符")
	@ExcelAttribute(name = "派单发起具体时间字典：0：15:20", maxLength = 10)
	@Schema(description = "派单发起具体时间字典：0：15:20")
	@ExcelProperty("派单发起具体时间字典：0：15:20")
	private String startTime;
	/**
	 * 派单确认时间，字典：0:派单发起当日
	 */
	@Length(max = 50, message = "派单确认时间，字典：0:派单发起当日 不能超过50 个字符")
	@ExcelAttribute(name = "派单确认时间，字典：0:派单发起当日", maxLength = 50)
	@Schema(description = "派单确认时间，字典：0:派单发起当日")
	@ExcelProperty("派单确认时间，字典：0:派单发起当日")
	private String confirmPeriod;
	/**
	 * 派单确认具体时间
	 */
	@Length(max = 10, message = "派单确认具体时间 不能超过10 个字符")
	@ExcelAttribute(name = "派单确认具体时间", maxLength = 10)
	@Schema(description = "派单确认具体时间")
	@ExcelProperty("派单确认具体时间")
	private String confirmTime;
	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@Length(max = 50, message = "项目ID 不能超过50 个字符")
	@ExcelAttribute(name = "项目ID", maxLength = 50)
	@Schema(description = "项目ID")
	@ExcelProperty("项目ID")
	private String deptId;


}
