/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoContractScheme;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoMainRel;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelAddVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelDetailVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 项目配置表主表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
public interface TAutoMainRelService extends IService<TAutoMainRel> {
    /**
     * 项目配置表主表简单分页查询
     * @param tAutoMainRel 项目配置表主表
     * @return
     */
    IPage<TAutoMainRel> getTAutoMainRelPage(Page<TAutoMainRel> page, TAutoMainRelSearchVo tAutoMainRel);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TAutoMainRelSearchVo searchVo);

    List<TAutoMainRelExportVo> noPageDiy(TAutoMainRelSearchVo searchVo);

    R<TAutoMainRelDetailVo> getByIdAsso(String id);

	R<Boolean> saveAsso(TAutoMainRelAddVo entity);

	R<Boolean> updateAsso(TAutoMainRelAddVo entity);

	R<TAutoMainRelDetailVo> getProjectRule(String deptId, String deptNo);

	IPage<TAutoContractScheme> getContractSchemePage(Page<TAutoContractScheme> page, TAutoContractScheme search);

	Map<String, String> getProjectAutoSetMap(List<String> departNos);
}
