/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzPushEntry;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzPushEntrySearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

/**
 * 瓜子系统交互任务跟进表
 *
 * @author cyx
 * @date 2025-07-09 17:03:50
 */
public interface TGzPushEntryService extends IService<TGzPushEntry> {
    /**
     * 瓜子系统交互任务跟进表简单分页查询
     * @param tGzPushEntry 瓜子系统交互任务跟进表
     * @return
     */
    IPage<TGzPushEntrySearchVo> getTGzPushEntryPage(Page<TGzPushEntry> page, TGzPushEntrySearchVo tGzPushEntry);

	/**
	 * 任务推送重试
	 * @param tGzPushEntry 瓜子系统交互任务跟进表
	 * @return R
	 */
	R<String> retryPushEntry(TGzPushEntry tGzPushEntry);

	/**
	 * 新增推送任务（异步）
	 * @param tGzPushEntry 瓜子系统交互任务跟进表
	 */
	void addPushEntry(TGzPushEntry tGzPushEntry);


}
