/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpMain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 预入职-主表
 *
 * @author hgw
 * @date 2024-06-17 11:31:08
 */
public interface TPreEmpMainService extends IService<TPreEmpMain> {
	/**
	 * 预入职-主表简单分页查询
	 *
	 * @param tPreEmpMain 预入职-主表
	 * @return
	 */
	IPage<TPreEmpMain> getTPreEmpMainPage(Page<TPreEmpMain> page, TPreEmpMainSearchVo tPreEmpMain);

	/**
	 * @Description: 详情
	 * @Author: hgw
	 * @Date: 2024/6/17 16:41
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpMain>
	 **/
	R<PreEmpMainDetailVo> getInfoById(String id);

	/**
	 * @Description:根据身份证与项目id获取信息
	 * @Author: hgw
	 * @Date: 2024/6/20 17:26
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.vo.PreEmpMainDetailVo>
	 **/
	R<PreEmpMainDetailVo> getByCardAndDeptId(String empIdCard, String deptId);

	// 单个完善信息
	R<String> doImproveInformation(PreEmpMainDetailVo vo);

	// 草稿
	R<String> saveDraftPreEmpMain(PreEmpMainDetailVo vo);

	// 保存
	R<String> savePreEmpMain(PreEmpMainDetailVo vo);

	// 批量完善信息
	R<List<ErrorMessage<String>>> importDiy(InputStream inputStream);

	// 导出
	void listExport(HttpServletResponse response, TPreEmpMainSearchVo searchVo);

	// 导出全量
	void exportAll(HttpServletResponse response, TPreEmpMainSearchVo searchVo);

	List<TPreEmpMain> noPageDiy(TPreEmpMainSearchVo searchVo);

	// 审核
	R<String> doAudit(String id, String status, String auditRemark);

	// 批量审核
	R<List<ErrorVO>> doBatchAudit(List<String> ids, String status, String auditRemark);

	/**
	 * @Description: 预入职批量导入
	 * @Author: hgw
	 * @Date: 2024/10/12 9:27
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.vo.PreEmpMainDetailVo>>
	 **/
	R<List<PreUploadEmpImportVo>> uploadPreEmp(MultipartFile file, PreUploadImportParamVo vo) throws Exception;

	/**
	 * 根据身份证与姓名查询用户手机号和来源
	 * @param empIdCard 身份证
	 * @param empName 姓名
	 * @author chenyuxi
	 * @date 2024-10-24 16:01:47
	 * @since mvp1.7.0
	 * @return EmpMainToCVo
	 **/
	R<EmpMainToCVo> getPhoneByCardAndName(String empIdCard, String empName);

	/**
	 * 发送手机验证码
	 *
	 * @param empPhone 手机号
	 * @return R<String>
	 *
	 * @author chenyuxi
	 * @date 2024-10-24 16:01:47
	 * @since mvp1.7.0
	 */
	R<String> sendCode(String empPhone);

	/**
	 * 校验手机验证码
	 *
	 * @param empPhone 手机号
	 * @param verifyCode 验证码
	 * @return R<String>
	 *
	 * @author chenyuxi
	 * @date 2024-10-24 16:01:47
	 * @since mvp1.7.0
	 */
	R<String> checkCode(String empPhone, String verifyCode);

    void exportEmpsFile(String departName,String departNo, String startDate, String endDate, HttpServletResponse response);

	R preEmpCount(String departNo, String startDate, String endDate);
}
