/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.res.template.DocumentInfo;
import com.fasc.open.api.v5_1.res.template.SignTemplateListInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddContractInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.FascService;
import com.yifu.cloud.plus.v1.yifu.archives.utils.FascUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 法大大合同与员工合同信息
 * @author fxj
 * @date 2022-06-29 16:21:51
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FascServiceImpl extends ServiceImpl<FddContractInfoMapper, FddContractInfo> implements FascService {

	@Autowired
	private FascUtil fascUtil;

	@Override
	public R<String> getTemplate(String templateName) throws ApiException {
		// templateName 签署任务模板名称
		List<SignTemplateListInfo> list = fascUtil.getTemplateList(templateName);
		if (list != null && !list.isEmpty()) {
			List<DocumentInfo> listDetail = fascUtil.getTemplateDetailList(list);
			// TODO-存表里
		}
		return R.ok();
	}


}
