package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprSocialProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Date 2022-7-27 19:37:14
 * @Description 社保定时任务
 * @Version 1.0
 */
@Component(value = "socialTask")
@Slf4j
@EnableConfigurationProperties(DaprSocialProperties.class)
public class SocialTask {

	@Autowired
	private DaprSocialProperties daprProperties;

	/**
	 * @Description: 定时生成基数配置新增的数据
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void updateForecastLibaryBySysBase() {
		log.info("------------定时生成基数配置新增的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/updateForecastLibaryBySysBase","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成基数配置新增的数据-定时任务结束------------");
	}

	/**
	 * @Description: 每月定时生成下月预估库数据
	 *
	 * 必须在【定时生成基数配置新增的数据】之后执行
	 *
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void everyMonthCreateForecastLibary() {
		log.info("------------每月定时生成下月预估库数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/everyMonthCreateForecastLibary","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------每月定时生成下月预估库数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保预估明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createForecastInfo() {
		log.info("------------定时生成社保预估明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/createForecastInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成社保预估明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金预估明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createForecastFundInfo() {
		log.info("------------定时生成公积金预估明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/createForecastFundInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成公积金预估明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentSocialInfo() {
		log.info("------------定时生成社保缴费库明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentSocialInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成社保缴费库明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentFundInfo() {
		log.info("------------定时生成公积金缴费库明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentFundInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成公积金缴费库明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保缴费库收入的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentInfoIncome() {
		log.info("------------定时生成缴费库社保的收入数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentInfoIncome","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成缴费库社保的收入数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentFundIncome() {
		log.info("------------定时生成缴费库公积金的收入数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentFundIncome","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成缴费库公积金的收入数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时任务生成统计表数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void pushDetail() {
		log.info("------------定时任务生成统计表数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincome/inner/pushDetail","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务生成统计表数据-定时任务结束------------");
	}


	/**
	 * @Description: 定时任务标识根据项目不需要生成收入的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void signPaymentNoIncomeFlag() {
		log.info("------------定时任务标识根据项目不需要生成收入的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/signPaymentNoIncomeFlag","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务标识根据项目不需要生成收入的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时任务生成月度截止日配置信息
	 * @Author: fxj
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createDeadLineSetInfo() {
		log.info("------------定时任务生成月度截止日配置信息定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialdeadlineinfo/inner/createDeadLineSetInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务生成月度截止日配置信息-定时任务结束------------");
	}

	/**
	 * @Description: 定时任务1月1号生成年度假期表
	 * @Author: fxj
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createHolidayInfo() {
		log.info("------------定时任务1月1号生成年度假期表-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tholidayinfo/inner/createHolidayInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务1月1号生成年度假期表-定时任务结束------------");
	}

	/**
	 * @Description: 1定时任务获取社保士兵状态
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void doInnerGetFiveJob() {
		log.info("------------1定时任务获取社保士兵状态-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerGetFiveJob","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------1定时任务获取社保士兵状态-定时任务结束------------");
	}

	/**
	 * @Description: 2定时任务推送社保士兵
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void doInnerPushSoldier() {
		log.info("------------2定时任务推送社保士兵-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerPushSoldier","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------2定时任务推送社保士兵-定时任务结束------------");
	}

	/**
	 * @Description: 1定时任务推送税友
	 * @Author: hgw
	 * @Date: 2024-12-9 17:00:02
	 **/
	public void doPushFriend() {
		log.info("------------1定时任务推送税友-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),
				"/tsocialfriend/inner/doPushFriend","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------1定时任务推送税友-定时任务结束------------");
	}
	/**
	 * @Description: 2定时任务获取税友
	 * @Author: hgw
	 * @Date: 2024-12-9 16:59:56
	 **/
	public void doGetFriendByRequestId() {
		log.info("------------2定时任务获取税友-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),
				"/tsocialfriend/inner/doGetFriendByRequestId","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------2定时任务获取税友-定时任务结束------------");
	}

	/**
	 * @Description: 3每日定时任务推送社保士兵审核结果查询
	 * @Author: hgw
	 * @Date: 2024-5-30 17:33:35
	 * @return: void
	 **/
	public void doInnerPushSoldierByAudit() {
		log.info("------------3每日定时任务推送社保士兵审核结果查询-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerPushSoldierByAudit","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------3每日定时任务推送社保士兵审核结果查询-定时任务结束------------");
	}

	/**
	 * @Description: 4每日定时任务获取社保士兵审核结果查询
	 * @Author: hgw
	 * @Date: 2024-5-30 17:33:35
	 * @return: void
	 **/
	public void doInnerGetSixJobByAudit() {
		log.info("------------4每日定时任务获取社保士兵审核结果查询-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerGetSixJobByAudit","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------4每日定时任务获取社保士兵审核结果查询-定时任务结束------------");
	}

	/**
	 * @Description: 5每月5号推送工资申报、调整（实缴使用）
	 * @Author: hgw
	 * @Date: 2024-5-30 17:33:35
	 * @return: void
	 **/
	public void doInnerPushSalaryByShenBao() {
		log.info("------------5每月5号推送工资申报、调整（实缴使用）-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerPushSalaryByShenBao","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------5每月5号推送工资申报、调整（实缴使用）-定时任务结束------------");
	}

	/**
	 * @Description: 6每月6号0点推送实缴3张表查询
	 * @Author: hgw
	 * @Date: 2024-6-6 10:54:39
	 * @return: void
	 **/
	public void doPushPaymentThree() {
		log.info("------------6每月6号1点推送实缴3张表查询-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doPushPaymentThree","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------6每月6号1点推送实缴3张表查询-定时任务结束------------");
	}

	/**
	 * @Description: 7每月6号3点定时任务获取社保士兵实缴3张表
	 * @Author: hgw
	 * @Date: 2024-6-6 10:54:43
	 * @return: void
	 **/
	public void doInnerGetPaymentThree() {
		log.info("------------7每月6号3点定时任务获取社保士兵实缴3张表-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsocialsoldier/inner/doInnerGetPaymentThree","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------7每月6号3点定时任务获取社保士兵实缴3张表-定时任务结束------------");
	}
	/**
	 * @Author fxj
	 * @Description 定时任务每月1日3点定时更新跨月的继续办理的数据为终止办理
	 * @Date 10:45 2025/7/14
	**/
	public void doChangeHandleStatusToEnd() {
		log.info("------------定时任务每月1日3点定时更新跨月的继续办理的数据为终止办理-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),
				"/tsocialfriend/inner/doChangeHandleStatusToEnd","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务每月1日3点定时更新跨月的继续办理的数据为终止办理-定时任务结束------------");
	}
}
