package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 审批主流程记录表节点表
 *
 * @author chenyuxi
 * @date 2025-01-10 17:47:32
 * @since 1.7.5
 */
@Data
@TableName("t_audit_node_process")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "审批主流程记录表节点表")
public class TAuditNodeProcess extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	@NotBlank(message = "流程id不能为空")
	@Length(max = 32, message = "流程id不能超过32个字符")
	@Schema(description = "流程id")
	private String processId;

	@NotBlank(message = "节点id不能为空")
	@Length(max = 32, message = "节点id不能超过32个字符")
	@Schema(description = "节点id")
	private String nodeId;

	@NotBlank(message = "节点类型不能为空")
	@Length(max = 32, message = "节点类型不能超过32个字符")
	@Schema(description = "节点类型")
	private String nodeType;

	@Length(max = 32, message = "实体id不能超过32个字符")
	@Schema(description = "实体id")
	private String domainId;

	@NotBlank(message = "0主流程，1子流程不能为空")
	@Length(max = 1, message = "0主流程，1子流程不能超过1个字符")
	@Schema(description = "0主流程，1子流程")
	private String mainType;

	@Length(max = 255, message = "节点标识不能超过255个字符")
	@Schema(description = "节点标识")
	private String logoTitle;

	@Length(max = 32, message = "节点名称不能超过32个字符")
	@Schema(description = "节点名称")
	private String nodeName;

	@Length(max = 32, message = "流程名称不能超过32个字符")
	@Schema(description = "流程名称")
	private String processName;

	@Length(max = 32, message = "父流程id不能超过32个字符")
	@Schema(description = "父流程id")
	private String parentProcessId;

	@Length(max = 1, message = "删除表示 0未删除 1删除不能超过1个字符")
	@Schema(description = "删除表示 0未删除 1删除")
	@TableLogic
	private String deleteFlag;

	@Length(max = 2, message = "审核类型 0客户新增 1.客户信息变更 2合同审核流程 3合同办理 4商机审核 5报价单 6团队共享不能超过2个字符")
	@Schema(description = "审核类型 0客户新增 1.客户信息变更 2合同审核流程 3合同办理 4商机审核 5报价单 6团队共享")
	private String type;

	@Length(max = 32, message = "加签节点的父节点id(不是加签节点的默认设置为0)不能超过32个字符")
	@Schema(description = "加签节点的父节点id(不是加签节点的默认设置为0)")
	private String addSignParentNodeId;

	@Length(max = 32, message = "加签节点的审核部门id(不是加签节点的默认设置为0)不能超过32个字符")
	@Schema(description = "加签节点的审核部门id(不是加签节点的默认设置为0)")
	private String addSignDepartmentId;

	@Length(max = 32, message = "实体名称不能超过32个字符")
	@Schema(description = "实体名称")
	private String domainName;

	@Length(max = 255, message = "加签人id不能超过255个字符")
	@Schema(description = "加签人id")
	private String addSignApprovalMan;

	@Length(max = 255, message = "加签人名字不能超过255个字符")
	@Schema(description = "加签人名字")
	private String addSignApprovalManName;

}
