/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 专项扣除配置表-薪资配置5
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSpecialDeducationSumVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;

	/**
	 * 导入月份
	 */
	@NotBlank(message = "导入月份 不能为空")
	@Length(max = 6, message = "导入月份 不能超过6 个字符")
	@ExcelAttribute(name = "导入月份", isNotEmpty = true, errorInfo = "导入月份 不能为空", maxLength = 6)
	@Schema(description = "导入月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("导入月份")
	private String createMonth;
	/**
	 * 申报单位
	 */
	@Length(max = 20, message = "申报单位 不能超过20 个字符")
	@ExcelAttribute(name = "申报单位", maxLength = 20)
	@Schema(description = "申报单位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String declareTitle;
	/**
	 * 工号
	 */
	@Length(max = 50, message = "工号 不能超过50 个字符")
	@ExcelAttribute(name = "工号", maxLength = 50)
	@Schema(description = "工号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工号")
	private String jobNumber;
	/**
	 * 姓名
	 */
	@Length(max = 20, message = "姓名 不能超过20 个字符")
	@ExcelAttribute(name = "姓名", maxLength = 20)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String name;
	/**
	 * 证照类型
	 */
	@Length(max = 20, message = "证照类型 不能超过20 个字符")
	@ExcelAttribute(name = "证照类型", maxLength = 20)
	@Schema(description = "证照类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证照类型")
	private String type;
	/**
	 * 证照号码
	 */
	@Length(max = 20, message = "证照号码 不能超过20 个字符")
	@ExcelAttribute(name = "证照号码", maxLength = 20)
	@Schema(description = "证照号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证照号码")
	private String idNumber;
	/**
	 * 所得期间起
	 */
	@Length(max = 20, message = "所得期间起 不能超过20 个字符")
	@ExcelAttribute(name = "所得期间起", maxLength = 20)
	@Schema(description = "所得期间起")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所得期间起")
	private String createStart;
	/**
	 * 所得期间止
	 */
	@Length(max = 20, message = "所得期间止 不能超过20 个字符")
	@ExcelAttribute(name = "所得期间止", maxLength = 20)
	@Schema(description = "所得期间止")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所得期间止")
	private String createEnd;
	/**
	 * 本期收入
	 */
	@ExcelAttribute(name = "本期收入")
	@Schema(description = "本期收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期收入")
	private BigDecimal currentIncome;
	/**
	 * 本期免税收入
	 */
	@ExcelAttribute(name = "本期免税收入")
	@Schema(description = "本期免税收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期免税收入")
	private BigDecimal currentIncomeTaxFree;
	/**
	 * 基本医疗保险费
	 */
	@ExcelAttribute(name = "基本医疗保险费")
	@Schema(description = "基本医疗保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基本医疗保险费")
	private BigDecimal insurancePension;
	/**
	 * 基本医疗保险费
	 */
	@ExcelAttribute(name = "基本医疗保险费")
	@Schema(description = "基本医疗保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("基本医疗保险费")
	private BigDecimal insuranceMedical;
	/**
	 * 失业保险费
	 */
	@ExcelAttribute(name = "失业保险费")
	@Schema(description = "失业保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业保险费")
	private BigDecimal insuranceUnemployment;
	/**
	 * 住房公积金
	 */
	@ExcelAttribute(name = "住房公积金")
	@Schema(description = "住房公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("住房公积金")
	private BigDecimal fund;
	/**
	 * 累计子女教育
	 */
	@ExcelAttribute(name = "累计子女教育")
	@Schema(description = "累计子女教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育")
	private BigDecimal sumChildEduMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@Schema(description = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal sumHousingLoanMoney;
	/**
	 * 累计住房租金
	 */
	@ExcelAttribute(name = "累计住房租金")
	@Schema(description = "累计住房租金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金")
	private BigDecimal sumHousingRentMoney;
	/**
	 * 累计赡养老人
	 */
	@ExcelAttribute(name = "累计赡养老人")
	@Schema(description = "累计赡养老人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人")
	private BigDecimal sumSupportElderlyMoney;
	/**
	 * 累计继续教育
	 */
	@ExcelAttribute(name = "累计继续教育")
	@Schema(description = "累计继续教育")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育")
	private BigDecimal sumContinuingEducationMoney;
	/**
	 * 累计3岁以下婴幼儿照护
	 */
	@ExcelAttribute(name = "累计3岁以下婴幼儿照护")
	@Schema(description = "累计3岁以下婴幼儿照护")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;
	/**
	 * 企业(职业)年金
	 */
	@ExcelAttribute(name = "企业(职业)年金")
	@Schema(description = "企业(职业)年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("企业(职业)年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 商业健康保险
	 */
	@ExcelAttribute(name = "商业健康保险")
	@Schema(description = "商业健康保险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("商业健康保险")
	private BigDecimal takingRisks;
	/**
	 * 税延养老保险
	 */
	@ExcelAttribute(name = "税延养老保险")
	@Schema(description = "税延养老保险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税延养老保险")
	private BigDecimal taxDeferredInsurance;
	/**
	 * 其他
	 */
	@ExcelAttribute(name = "其他")
	@Schema(description = "其他")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("其他")
	private BigDecimal otherMoney;
	/**
	 * 准予扣除的捐赠额
	 */
	@ExcelAttribute(name = "准予扣除的捐赠额")
	@Schema(description = "准予扣除的捐赠额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("准予扣除的捐赠额")
	private BigDecimal donationAmount;
	/**
	 * 税前扣除项目合计
	 */
	@ExcelAttribute(name = "税前扣除项目合计")
	@Schema(description = "税前扣除项目合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税前扣除项目合计")
	private BigDecimal preTaxDeduction;
	/**
	 * 减免税额
	 */
	@ExcelAttribute(name = "减免税额")
	@Schema(description = "减免税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减免税额")
	private BigDecimal taxSavings;
	/**
	 * 减除费用
	 */
	@ExcelAttribute(name = "减除费用")
	@Schema(description = "减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("减除费用")
	private BigDecimal costReduction;
	/**
	 * 已扣缴税额
	 */
	@ExcelAttribute(name = "已扣缴税额")
	@Schema(description = "已扣缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("已扣缴税额")
	private BigDecimal taxesWithheld;
	/**
	 * 备注
	 */
	@Length(max = 500, message = "备注 不能超过500 个字符")
	@ExcelAttribute(name = "备注", maxLength = 500)
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;

}
