/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.admin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysDictItem;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysOutRelDictItem;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysDictItemMapper;
import com.yifu.cloud.plus.v1.yifu.admin.mapper.SysOutRelDictItemMapper;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysOutRelDictItemService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ClientNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;

/**
 * 外部字典值数据表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class SysOutRelDictItemServiceImpl extends ServiceImpl<SysOutRelDictItemMapper, SysOutRelDictItem> implements SysOutRelDictItemService {

	private final SysDictItemMapper dictItemMapper;

    @Override
    public List<SysOutRelDictItem> noPageDiy(SysOutRelDictItem searchVo) {

        return null;
    }

	@Override
	public Map<String, Map<String,String>> getRelValueMapByOutDictType() {
		Map<String, Map<String,String>> resMap = new HashMap<>();
		LambdaQueryWrapper<SysOutRelDictItem> relDictItemQuery = Wrappers.<SysOutRelDictItem>lambdaQuery()
				.eq(SysOutRelDictItem::getClientId, ClientNameConstants.CLIENT_GZ);
		List<SysOutRelDictItem> relDictItemList = this.list(relDictItemQuery);
		if(Common.isNotNull(relDictItemList)){
			for(SysOutRelDictItem outRelDictItem :relDictItemList){
				Map<String, String> relDictItemMap = resMap.get(outRelDictItem.getDictType());
				if(Common.isEmpty(relDictItemMap)){
					relDictItemMap = new HashMap<>();
				}
				relDictItemMap.put(outRelDictItem.getValue(),outRelDictItem.getSysDictValue());
				resMap.put(outRelDictItem.getDictType(),relDictItemMap);
			}
		}

		// 获取瓜子紧急联系人
		LambdaQueryWrapper<SysDictItem> emergRelationItemQuery = Wrappers.<SysDictItem>lambdaQuery()
				.eq(SysDictItem::getDelFlag, CommonConstants.ZERO_STRING)
				.eq(SysDictItem::getDisable, CommonConstants.ZERO_STRING)
				.in(SysDictItem::getType, "gz_emerg_relation")
				.eq(SysDictItem::getClientId, ClientNameConstants.CLIENT_GZ);
		List<SysDictItem> emergRelationItemList = dictItemMapper.selectList(emergRelationItemQuery);
		if(Common.isNotNull(emergRelationItemList)){
			for(SysDictItem emergRelationItem : emergRelationItemList){
				Map<String, String> relDictItemMap = resMap.get("gz_emerg_relation");
				if(Common.isEmpty(relDictItemMap)){
					relDictItemMap = new HashMap<>();
				}
				relDictItemMap.put(emergRelationItem.getValue(),emergRelationItem.getLabel());
				resMap.put("gz_emerg_relation",relDictItemMap);
			}
		}

		return resMap;
	}
}
