package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceDetail;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 商险已投保修改请求参数
 * @date 2022-12-08 18:32:11
 */
@Data
@Schema(description = "商险已投保修改请求参数")
public class InsuranceInsuredParam implements Serializable {
	private static final long serialVersionUID = -6131541135370797891L;
	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 变更后的购买标准
	 */
	@Schema(description = "变更后的购买标准")
	private String buyStandardNew;

	/**
	 * 变更后保单开始时间
	 */
	@Schema(description = "变更后保单开始时间")
	private String policyStartNew;

	/**
	 * 变更后保单结束时间
	 */
	@Schema(description = "变更后保单结束时间")
	private String policyEndNew;

	/**
	 * 变更后投保类型
	 */
	@Schema(description = "变更后投保类型， 新增、批增")
	private String buyTypeStr;

	/**
	 * 变更后投保类型
	 */
	@JsonIgnore
	private Integer buyType;

	/**
	 * 变更原因
	 */
	@Schema(description = "变更原因")
	private String reason;


	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

	/**
	 * 错误标志 0 正确 1错误
	 */
	@Schema(description = "错误标志")
	private String flag;

	/**
	 * 数据传递对象
	 */
	@JsonIgnore
	private TInsuranceDetail detail;
}
