/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 员工合同续签待办-批量更新的VO
 *
 * @author hgw
 * @date 2023-7-17 10:50:47
 */
@Data
@Schema(description = "员工合同续签待办-批量更新的VO")
public class EmpContractAlertUpdateVO extends RowIndex implements Serializable {

	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名")
	@Schema(description = "姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdCard;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	private String projectNo;

	/**
	 * 未续签原因
	 */
	@ExcelAttribute(name = "未续签原因")
	@Schema(description = "未续签原因")
	private String feedbackReason;

	/**
	 * 具体描述
	 */
	@ExcelAttribute(name = "具体描述")
	@Schema(description = "具体描述")
	private String feedbackDetail;

	/**
	 * 异常原因
	 */
	@ExcelAttribute(name = "异常原因")
	@Schema(description = "异常原因")
	private String errorInfo;

}
