package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompanyInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TProveApply;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TProveApplyMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TProveApplyService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.util.RedisUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@Service
public class TProveApplyServiceImpl extends ServiceImpl<TProveApplyMapper, TProveApply> implements TProveApplyService {
	@Autowired
	private RedisUtil redisUtil;
	@Autowired
	private TAttaInfoService tAttaInfoService;

	/**
	 * 简单分页查询
	 *
	 * @param tProveApply
	 * @return
	 */
	@Override
	public IPage<TProveApply> getTProveApplyPage(Page<TProveApply> page, TProveApply tProveApply) {
		return baseMapper.getTProveApplyPage(page, tProveApply);
	}

	@Override
	public R<String> validSave(TProveApply proveApply, String[] attaIdArray) {
		YifuUser user = SecurityUtils.getUser();
		//查重
		long count = this.count(Wrappers.<TProveApply>lambdaQuery()
				.eq(TProveApply::getEmployeeInfo, proveApply.getEmployeeInfo())
				.eq(TProveApply::getStartMonth, proveApply.getStartMonth())
				.eq(TProveApply::getEndMonth, proveApply.getEndMonth())
				.eq(TProveApply::getSumType, proveApply.getSumType())
				.ne(TProveApply::getAuditStatus, CommonConstants.dingleDigitStrArray[2]));
		if (count > 0) {
			return R.failed("该员工这段时间内已存在申请记录");
		}
		proveApply.setId(null);
		//初始化数据填充
		proveApply.setAuditStatus(CommonConstants.ZERO_STRING);//待审核
		proveApply.setCreatDate(new Date());
		proveApply.setCreatUser(user.getId());
		proveApply.setCreatUserName(user.getNickname());
		//保存数据
		this.save(proveApply);

		if (Common.isNotNull(attaIdArray)) {
			//保存关系
			List<TAttaInfo> mList = new ArrayList<>();
			TAttaInfo m;
			for (String id : attaIdArray) {
				m = new TAttaInfo();
				m.setId(id);
				m.setDomainId(proveApply.getId());
				mList.add(m);
			}
			tAttaInfoService.updateBatchById(mList);
		}
		return R.ok("操作成功！");
	}

	@Override
	public R<TCompanyInfo> getLastCompanyName() {
		YifuUser user  = SecurityUtils.getUser();
		if (Common.isEmpty(user)){
			return R.failed(CommonConstants.USER_FAIL);
		}
		String userKey = CacheConstants.WXHR_LAST_SELECT_COMPANY_NAME + "_" + user.getId();
		Object info = redisUtil.get(userKey);
		if(Common.isEmpty(info)){
			return R.ok(null);
		}
		return R.ok((TCompanyInfo)info);
	}

	@Override
	public void setCompanyRedisInfo(String unitName, String unitAddr, String phone) {
		YifuUser user  = SecurityUtils.getUser();
		if (!Common.isEmpty(user)){
			String userKey = CacheConstants.WXHR_LAST_SELECT_COMPANY_NAME + "_" + user.getId();
			TCompanyInfo info = new TCompanyInfo();
			info.setCompanyName(unitName);
			info.setCompanyTel(phone);
			info.setCompanyAddress(unitAddr);
			redisUtil.set(userKey,info);
		}
	}
}
