package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author hgw
 * @Description 社保士兵养工失增加模板
 * @Date 2024-5-10 21:05:29
 **/
@Data
public class SociaFriendYgsAddVo implements Serializable {

	// 社保id，用于回写
	@ExcelIgnore
	private String socialId;
	@ExcelProperty("社保户")
	private String socialHouseholdName;
	// 户配置的“单位统一信用代码”
	private String unitCreditCode;
	// "行政区划代码"
	private String areaCode;
	// "社保-登录账户"
	private String socialAccount;
	// "社保-登录密码"
	private String socialPassword;
	// "医保-登录账户"
	private String mediclAccount;
	// "医保-登录密码"
	private String mediclPassword;
	// "单位编号"
	private String customerNo;
	// "单位编号" 医保
	private String customerNoYsd;
	@ExcelProperty("员工姓名")
	private String empName;
	@ExcelProperty("员工身份证")
	private String empIdcard;
	@ExcelProperty("民族")
	private String empNational;
	@ExcelProperty("手机号码")
	private String empMobile;
	// yyyy-MM-dd
	@ExcelProperty("社保起缴日期")
	private String socialStartDate;
	// whcd 见字典“受教育程度” 空的默认“大学专科”
	@ExcelProperty("学历")
	private String educationName;
	@ExcelProperty("备案基数")
	private String recordBase;
	// yyyyMM
	@ExcelProperty("社保起缴月")
	private String socialStartMonth;

	// 用工形式ygxs contractType
	// 0 订立以完成一定工作任务为期限的劳动合同 1 订立固定期限劳动合同 2 订立无固定期限劳动合同
	private String contractType;
	// 工作时间制度 派单表的 工时制 1=标准工作时间制度,2=综合计算工时制度,3=不定时工作时间制度
	@ExcelProperty("工时制")
	private String workingHours;
	// 0 以完成一定工作为期限的劳动合同 1 固定期限劳动合同 2 无固定期限劳动合同
	private String contractTypeTwo;
	// "合同到期时间" 劳动合同截止日期 yyyy-MM-dd
	@ExcelProperty("合同到期时间")
	private String contractEnd;
	// 中断原因 除死亡以外，其他停保原因默认：“在职人员解除/终止劳动合同” 死亡对应“死亡或失踪”
	@ExcelProperty("中断原因")
	private String tbyy;
	// 单位提出协商一致21 职工与用人单位协商一致解除劳动合同(18条1款)
	// 退休5 第四十四条第二项，劳动者开始依法享受基本养老保险待遇
	//死亡16 劳动者死亡，或者被人民法院宣告死亡或者宣告失踪
	//个人辞职1 劳动者提前30天书面通知解除或试用期提前3天通知解除合同
	//其他20 法律、行政法规规定的其他情形
	//合同期满12 劳动合同期满
	//单位辞退2 劳动者严重违反用人单位的规章制度
	// 其他的默认 个人辞职1 劳动者提前30天书面通知解除或试用期提前3天通知解除合同 2024-12-12 09:19:59 昨晚盛宇沟通的结果
	@ExcelProperty("劳动用工备案解除/终止原因")
	private String zzyy;

	// 企业职工社会保险增员花名册 qyzgshbxzyhmc
	private String qyzgshbxzyhmc;
	// 单个附件list
	private List<String> imgList;
	// 当前行政经办区——2025-3-31 10:23:02 盛宇与税友沟通，可以默认安徽省，暂时不用这个字段了，后面有特殊要求再加
	/*@ExcelProperty("当前行政经办区
	private String dqxzjbq*/
	// 毕业院校
	@ExcelProperty("毕业院校")
	private String byyx;
	// 企业职工基本医疗保险参保登记表 qyzgshbxzyhmc
	private String qyzgjbylbxcbdjb;

	private String socialProvince;
	private String socialCity;
	private String socialTown;

	@ExcelProperty("单位医疗金额标志，1有，0无" )
	private Integer unitMedicalMoney;
	@ExcelProperty("单位生育金额标志，1有，0无" )
	private Integer unitBirthMoney;
	@ExcelProperty("单位大病救助金额标志，1有，0无" )
	private Integer unitBigailmentMoney;


	@ExcelProperty("派单类型")
	private String type;

	@ExcelProperty("备案解除二级原因")
	private String bajcejyy;

	@ExcelProperty("是否单个")
	private String isSingle;
	// 用来获取单个推送的附件
	@ExcelProperty("派单ID")
	private String dispatchId;

}
