package com.yifu.cloud.plus.v1.yifu.archives.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description: 分页查询VO
 * @author: wangweiguo
 * @date: 2021/8/10
 */

@Setter
@Getter
@ToString
public class BusinessEmployeeExtendListVO implements Serializable {
    /**
     * 项目人员表主键
     */
    @Schema(description = "项目人员表主键", name = "id")
    private String id;

    /**
     * 人员表主键
     */
    @Schema(description = "人员表主键", name = "empId")
    private String empId;

	/**
     * 人员拓展表主键
     */
    @Schema(description = "人员拓展表主键", name = "extendId")
    private String extendId;

    /**
     * 姓名
     */
    @Schema(description = "姓名", name = "empName")
    private String empName;
    
    /**
     * 身份证号
     */
    @Schema(description = "身份证号")
    private String empIdcard;
    
    /**
     * 入职日期
     */
    @Schema(description = "入职日期", name = "businessEnjoinDate")
    private LocalDate businessEnjoinDate;
    /**
     * 业务项目
     */
    @Schema(description = "业务项目", name = "settleDomain")
    private String settleDomain;

    /**
     * 部门名称
     */
    @Schema(description ="所属部门")
    private String departName;

    /**
     * 部门id
     */
    @Schema(description ="部门id")
    private Integer departId;

    /**
     * b端岗位
     */
    @Schema(description ="岗位")
    private String businessPost;

    /**
     * b端员工工号
     */
    @Schema(description ="电信工号")
    private String businessTelecomNumber;

    /**
     * 标签，字典值（英文逗号分割）
     */
    @Schema(description ="标签，字典值（英文逗号分割）")
    private String employeeTags;

    /**
     * B端在职状态 0在职 1离职 3临时
     */
    @Schema(description ="B端在职状态 0在职 1离职 3临时")
    private String businessWorkingStatus;

    /**
     * hro在职状态 0 在职 1 离职
     */
    @Schema(description ="职状态 0 在职 1 离职 和businessWorkFlag字段联合判断临时")
    private String workFlag;

    /**
     * hro在职状态 3临时
     */
    @Schema(description ="3 临时，其他状态不判断")
    private String workingStatusSub;

    /**
     * B端维护的离职时间
     */
    @Schema(description ="B端维护的离职时间")
    private LocalDateTime businessLeaveDate;

    /**
     * 证件类型 逗号分割
     */
    @Schema(description ="证件类型 逗号分割")
    private String documentType;

    /**
     * 结算主体名称
     */
    @Schema(description ="结算主体名称")
    private String settleDomainName;

}
