/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * CSP客户服务平台-花名册
 * @author hgw
 * @date 2025-2-28 18:10:00
 */
@Data
@ColumnWidth(30)
public class EmployeeProjectScpVO implements Serializable {

	private static final long serialVersionUID = 1L;

	@ExcelAttribute(name = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;

	@ExcelAttribute(name = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "员工手机号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工手机号")
	private String empPhone;

	@ExcelAttribute(name = "所属部门", maxLength = 30)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属部门")
	private String empDeptname;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "就职岗位")
	@ExcelAttribute(name = "就职岗位")
	private String post;

	// （0在职；1离职
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "在职状态")
	@ExcelAttribute(name = "在职状态")
	private String projectStatus;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "入/离职日期")
	@ExcelAttribute(name = "入/离职日期")
	private String enjoinDateAndLeaveTime;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "合同签订状态")
	@ExcelAttribute(name = "合同签订状态", isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_STATE)
	private String contractStatus;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险购买状态")
	@ExcelAttribute(name = "商险购买状态", isDataId = true, dataType = ExcelAttributeConstants.COMMERCIAL_SATTE)
	private String insuranceStatus;
}
