/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpWorkRecording;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpWorkRecordingService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.WorkRecordSearchVO;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;


/**
 * 员工工作履历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempworkrecording" )
@Tag(name = "员工工作履历信息表管理")
public class TEmpWorkRecordingController {

    private final TEmpWorkRecordingService tEmpWorkRecordingService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param tEmpWorkRecording 员工工作履历信息表
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    public R<IPage<TEmpWorkRecording>> getTEmpWorkRecordingPage(Page page, WorkRecordSearchVO tEmpWorkRecording) {
        return R.ok(tEmpWorkRecordingService.pageDiy(page, tEmpWorkRecording));
    }

	/**
	 * 不分页查询
	 * @param searchVo 员工工作履历信息表
	 * @return
	 */
	@Operation(description = "不分页查询")
	@PostMapping("/noPage" )
	public R<List<TEmpWorkRecording>> getTEmpWorkRecordingNoPage(@RequestBody WorkRecordSearchVO searchVo) {
		return R.ok(tEmpWorkRecordingService.getTEmpWorkRecordingNoPage(searchVo));
	}
    /**
     * 通过id查询员工工作履历信息表
     * @param id id
     * @return R
     */
    @Operation(description = "通过id查询hasPermission('archives_tempworkrecording_get')")
    @GetMapping("/{id}" )
    public R<TEmpWorkRecording> getById(@PathVariable("id" ) String id) {
        return R.ok(tEmpWorkRecordingService.getById(id));
    }

    /**
     * 新增员工工作履历信息表
     * @param tEmpWorkRecording 员工工作履历信息表
     * @return R
     */
    @Operation(description = "新增员工工作履历信息表hasPermission('archives_tempworkrecording_add')")
    @SysLog("新增员工工作履历信息表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_tempworkrecording_add')" )
    public R<Boolean> save(@RequestBody TEmpWorkRecording tEmpWorkRecording) {
		tEmpWorkRecording.setDeleteFlag(CommonConstants.ZERO_STRING);
        return tEmpWorkRecordingService.saveDiy(tEmpWorkRecording);
    }

    /**
     * 修改员工工作履历信息表
     * @param tEmpWorkRecording 员工工作履历信息表
     * @return R
     */
    @Operation( description = "修改员工工作履历信息表hasPermission('archives_tempworkrecording_edit')")
    @SysLog("修改员工工作履历信息表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('archives_tempworkrecording_edit')" )
    public R<Boolean> updateById(@RequestBody TEmpWorkRecording tEmpWorkRecording) {
        return tEmpWorkRecordingService.updateByIdDiy(tEmpWorkRecording);
    }

    /**
     * 通过id删除员工工作履历信息表
     * @param id id
     * @return R
     */
    @Operation(description = "通过id删除员工工作履历信息表hasPermission('archives_tempworkrecording_del')")
    @SysLog("通过id删除员工工作履历信息表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tempworkrecording_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tEmpWorkRecordingService.removeById(id));
    }

	/**
	 * 通过id删除员工工作信息表
	 * @param ids
	 * @return R
	 */
	@Operation(description = "通过id删除员工工作信息表 @pms.hasPermission('archives_tempworkrecording_del_batch')")
	@SysLog("通过id删除员工家工作息表" )
	@DeleteMapping("/removeByIds" )
	@PreAuthorize("@pms.hasPermission('archives_tempworkrecording_del_batch')" )
	public R<Boolean> removeByIds(@RequestBody(required = true) String[] ids) {
		List<String> idList = Arrays.asList(ids);
		return R.ok(tEmpWorkRecordingService.removeByIds(idList));
	}

	/**
	 * 批量新增员工工作信息
	 *
	 * @param file
	 * @return
	 * @Author fxj
	 * @Date 2019-08-16
	 **/
	@SneakyThrows
	@Operation(description = "批量新增员工工作信息 hasPermission('archives_tempworkrecording_importListAdd')")
	@SysLog("批量新增员工工作信息")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('archives_tempworkrecording_importListAdd')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tEmpWorkRecordingService.importEmpWorkRecordDiy(file.getInputStream());
	}
}
