/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplateDetail;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateDetailSearchVo;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 法大大专业版模板映射表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
public interface TFascTemplateDetailService extends IService<TFascTemplateDetail> {
    /**
     * 法大大专业版模板映射表简单分页查询
     * @param tFascTemplateDetail 法大大专业版模板映射表
     * @return
     */
    IPage<TFascTemplateDetail> getTFascTemplateDetailPage(Page<TFascTemplateDetail> page, TFascTemplateDetailSearchVo tFascTemplateDetail);

	// 获取列表
    List<TFascTemplateDetail> getTDetailListByFieldType(String fadadaTemplateId);

    List<TFascTemplateDetail> getTFascTemplateDetailList(TFascTemplateDetail tFascTemplateDetail);

    R<List<ErrorMessage>> batchUpdateFascDetail(InputStream inputStream);

    void listExport(HttpServletResponse response, TFascTemplateDetailSearchVo searchVo);

	/**
	 * @Description: 变更合同类型，清空配置好的皖信字段，并重新计算模板表必填是否已配置
	 * @Author: hgw
	 * @Date: 2025/10/10 16:35
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	void initDetailHrField(String templateId);

	/**
	 * @Description: 重新刷新主模板表的必填是否已填
	 * @Author: hgw
	 * @Date: 2025/10/10 16:35
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> initFascTemplateIsMust(String templateId);

    List<TFascTemplateDetail> noPageDiy(TFascTemplateDetailSearchVo searchVo);
}
