package com.yifu.cloud.plus.v1.business.service.cert;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.dto.vacation.UpdateVacationRedundancyDTO;
import com.yifu.cloud.plus.v1.business.entity.cert.TCertInfo;
import com.yifu.cloud.plus.v1.business.vo.cert.TCertInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 人员证书信息表
 *
 * @author fxj
 * @date 2021-08-16 15:34:16
 */
public interface TCertInfoService extends IService<TCertInfo> {

    /**
     * 人员证书信息表简单分页查询
     *
     * @param tCertInfo 人员证书信息表
     * @return
     */
    IPage<TCertInfo> getTCertInfoPage(Page<TCertInfo> page, TCertInfo tCertInfo);


    R<List<ErrorMessage>> batchImportCertByJsonStr(String jsonStr);

    R<TCertInfo> saveAsso(TCertInfo tCertInfo);

    R<String> updateByIdDiy(TCertInfo tCertInfo);

    R<TCertInfoVo> getVoById(String id);

    R<List<TCertInfoVo>> getByEmpIdcard(String empIdcard);

    R<Boolean> removeByIdDiy(String id);

    R<List<ErrorMessage>> batchUpdateCertByJsonStr(String jsonStr);

    List<TCertInfo> getCertInfoForExport(TCertInfo tCertInfo);

    R<Boolean> updateCertStatusTask();

    R<List<ErrorMessage>> updateRedundancyEmpOfCert(List<UpdateVacationRedundancyDTO> dtoList);
}
