package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
@Data
@TableName("t_insurance_unpurchase_person")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "含风险项目不购买申请明细表")
public class TInsuranceUnpurchasePerson extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	@Schema(description = "父级id")
	private String parnetId;

	@Schema(description = "姓名")
	private String empName;

	@Schema(description = "身份证号")
	private String empIdcardNo;

	@Schema(description = "就职岗位")
	private String post;

	@Schema(description = "明细申请编号")
	private String applyNoDetail;

	@Schema(description = "项目ID")
	private String deptId;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "申请人所在部门")
	private String createUserDeptId;

	@Schema(description = "申请人所在部门名称")
	private String createUserDeptName;

	@Schema(description = "不购买原因 1 已购买社保 2 人员已离职")
	private String reasonType;

	@Schema(description = "原因说明")
	private String reasonInfo;

	@Schema(description = "主表申请编号")
	private String applyNo;

	@Schema(description = "社保是否在保 0 是 1 否")
	private String socialStatus;

	@Schema(description = "发薪次数")
	private Integer salaryNum;

	@Schema(description ="是否含风险")
	private String hasContainRisks;

	@Schema(description ="事业部条线")
	private String newLine;

	@Schema(description ="事业部")
	private String division;

	@Schema(description ="服务项是否勾选商险 0 是 1 否")
	private String insuranceFlag;

	@Schema(description = "申请状态 0 草稿 1待提交 2 待审核 3 审核通过 4 审核不通过")
	private String status;

	/**
	 * 1.9.7版本新增：历史申请日期(流程通过)
	 * 陈宇茜
	 */
	private String historicalApplicationDate;

	/**
	 * 印章附件
	 */
	@TableField(exist = false)
	private List<TSalaryAtta> attaInfoList;

	@Schema(description = "工资人员明细")
	@TableField(exist = false)
	private List<TInsuranceUnpurchasePersonSalary> personInfoList;

}
