/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpMainLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TPreEmpMainLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 预入职审批记录表
 *
 * @author hgw
 * @date 2024-06-24 14:27:15
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpreempmainlog")
@Tag(name = "预入职审批记录表管理")
public class TPreEmpMainLogController {

	private final TPreEmpMainLogService tPreEmpMainLogService;

	/**
	 * 不分页查询
	 *
	 * @return
	 */
	@Operation(summary = "获取list", description = "获取list")
	@PostMapping("/getTPreEmpMainLogList")
	public R<List<TPreEmpMainLog>> getTPreEmpMainLogList(@RequestParam String mainId) {
		return R.ok(tPreEmpMainLogService.getTPreEmpMainLogList(mainId));
	}

}
