/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddTemplateFieldInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddTemplateFieldInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddTemplateFieldInfoService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 法大大字段对应信息表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Service
@RequiredArgsConstructor
public class FddTemplateFieldInfoServiceImpl extends ServiceImpl<FddTemplateFieldInfoMapper, FddTemplateFieldInfo> implements FddTemplateFieldInfoService {

	/**
	 * @ClassName: com.yifu.cloud.v1.hr.basicArchives.service.impl.FddTemplateFieldInfoServiceImpl.java
	 * @author huyc
	 * @date 2022/6/30
	 * @Description 按模板和角色获取具体字段参数
	 * @param templateId： 模板ID type：0 个人角色 1 公司角色
	 */
	@Override
	public List<FddTemplateFieldInfo> getFddFields(String templateId, String type) {
		return baseMapper.selectList(Wrappers.<FddTemplateFieldInfo>query().lambda()
				.eq(FddTemplateFieldInfo::getType,type)
				.eq(FddTemplateFieldInfo::getTemplateId,templateId));
	}
}
