package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * B端附件表
 *
 * @author hgw
 * @date 2021-08-12 16:38:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_atta_info")
@Schema(description = "B端附件表")
public class TBusAttaInfo extends Model<TBusAttaInfo> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 资源名称
      */
     @NotBlank(message = "资源名称不能为空")
     @Length(max = 50, message = "资源名称不能超过50个字符")
     @ExcelAttribute(name = "资源名称", isNotEmpty = true, errorInfo = "资源名称不能为空", maxLength = 50)
     @Schema(description = "资源名称")
     private String attaName;
     /**
      * 资源地址
      */
     @NotBlank(message = "资源地址不能为空")
     @Length(max = 100, message = "资源地址不能超过100个字符")
     @ExcelAttribute(name = "资源地址", isNotEmpty = true, errorInfo = "资源地址不能为空", maxLength = 100)
     @Schema(description = "资源地址")
     private String attaSrc;
     /**
      * 资源大小
      */
     @ExcelAttribute(name = "资源大小")
     @Schema(description = "资源大小")
     private Long attaSize;
     /**
      * 资源类型
      */
     @Length(max = 10, message = "资源类型不能超过10个字符")
     @ExcelAttribute(name = "资源类型", maxLength = 10)
     @Schema(description = "资源类型")
     private String attaType;
     /**
      * 创建人id
      */
     @Length(max = 32, message = "创建人id不能超过32个字符")
     @ExcelAttribute(name = "创建人id", maxLength = 32)
     @Schema(description = "创建人id")
     private String createUserId;
     /**
      * 创建人姓名
      */
     @Length(max = 50, message = "创建人姓名不能超过50个字符")
     @ExcelAttribute(name = "创建人姓名", maxLength = 50)
     @Schema(description = "创建人姓名")
     private String createUserName;
     /**
      * 创建时间
      */
     @ExcelAttribute(name = "创建时间")
     @Schema(description = "创建时间")
     private LocalDateTime createTime;
     /**
      * 实体id和关系类型共同确定附件所属
      */
     @Length(max = 32, message = "实体id和关系类型共同确定附件所属不能超过32个字符")
     @ExcelAttribute(name = "实体id和关系类型共同确定附件所属", maxLength = 32)
     @Schema(description = "实体id和关系类型共同确定附件所属")
     private String relationId;
     /**
      * 关系类型(0结算单；1社保；2公积金；3代发工资；4餐补；5春节大礼包；6证件附件)
      */
     @Length(max = 1, message = "关系类型(0结算单；1社保；2公积金；3代发工资；4餐补；5春节大礼包；6证件附件;7假勤信息附件8学信网证明)不能超过1个字符")
     @ExcelAttribute(name = "关系类型", isNotEmpty = true, errorInfo = "关系类型不能为空", maxLength = 1)
     @Schema(description = "关系类型(0结算单；1社保；2公积金；3代发工资；4餐补；5春节大礼包；6证件附件;7假勤信息附件8学信网证明)")
     private Integer relationType;
}
