package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;


/**
 * 购买标准表
 * @TableName t_insurance_type_standard
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_type_standard")
@Tag(name = "购买标准表")
public class TInsuranceTypeStandard extends BaseEntity {

    /**
     * 购买标准id
     */
	@Schema(description = "购买标准id")
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 险种主键ID
     */
	@Schema(description = "险种主键ID")
	@NotBlank(message = "险种主键ID不能为空")
    private String insuranceTypeId;

    /**
     * 购买标准
     */
	@Schema(description = "购买标准")
	@NotBlank(message = "购买标准不能为空")
    private String buyStandard;

    /**
     * 医疗额度
     */
	@Schema(description = "医疗额度")
	@NotBlank(message = "医疗额度不能为空")
    private String medicalQuota;

    /**
     * 身故或残疾额度
     */
	@Schema(description = "身故或残疾额度")
	@NotBlank(message = "身故或残疾额度不能为空")
    private String dieDisableQuota;

	/**
	 * 删除标志(0：未删除，1：删除)
	 */
	@Schema(description = "是否删除 0否/1是")
	private Integer deleteFlag;
}