package com.yifu.cloud.plus.v1.job.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.job.entity.SysScheduleJobLog;
import com.yifu.cloud.plus.v1.job.service.SysScheduleJobLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * @Author fxj
 * @Description
 * @Date 11:18 2022/6/15
 * @Param
 * @return
**/
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysschedulejoblog")
@Tag(name="任务执行日志",description = "任务执行日志")
public class SysScheduleJobLogController {

    private final SysScheduleJobLogService sysScheduleJobLogService;

    /**
     * 简单分页查询
     *
     * @param page              分页对象
     * @param sysScheduleJobLog
     * @return
     */
	@Operation(summary = "简单分页查询", description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<SysScheduleJobLog>> getSysScheduleJobLogPage(Page<SysScheduleJobLog> page, SysScheduleJobLog sysScheduleJobLog) {
        return new R<>(sysScheduleJobLogService.getSysScheduleJobLogPage(page, sysScheduleJobLog));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "id查询", description = "id查询")
    @GetMapping("/{id}")
    public R<SysScheduleJobLog> getById(@PathVariable("id") String id) {
        return new R<>(sysScheduleJobLogService.getById(id));
    }

    /**
     * 新增记录
     *
     * @param sysScheduleJobLog
     * @return R
     */
	@Operation(summary = "新增", description = "新增")
    @PostMapping
    @PreAuthorize("@pms.hasPermission('wxhr:sysschedulejoblog_add')")
    public R save(@Valid @RequestBody SysScheduleJobLog sysScheduleJobLog) {
        return new R<>(sysScheduleJobLogService.save(sysScheduleJobLog));
    }

    /**
     * 修改记录
     *
     * @param sysScheduleJobLog
     * @return R
     */
	@Operation(summary = "修改", description = "修改")
    @SysLog("修改")
    @PutMapping
    @PreAuthorize("@pms.hasPermission('wxhr:sysschedulejoblog_edit')")
    public R update(@RequestBody SysScheduleJobLog sysScheduleJobLog) {
        return new R<>(sysScheduleJobLogService.updateById(sysScheduleJobLog));
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "删除", description = "删除")
    @SysLog("删除")
    @DeleteMapping("/{id}")
    @PreAuthorize("@pms.hasPermission('wxhr:sysschedulejoblog_del')")
    public R removeById(@PathVariable String id) {
        return new R<>(sysScheduleJobLogService.removeById(id));
    }

}
